<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Website extends CI_Controller {

    public function __construct() {
        parent::__construct();

        // Check if agent is logged in
        if (!$this->session->userdata('logged_in') || $this->session->userdata('log_user') != 'agent') {
            // Not logged in or not an agent, redirect to login page
            redirect(base_url());
        }
    }

    private function header_and_footer($page, $data = []) {
        $this->load->view('website/includes/header', $data);
        $this->load->view('website/'.$page, $data);
        $this->load->view('website/includes/footer');
    }

    public function index() {
        $data['title'] = 'Home';     
		$data['packages'] = $this->website_model->getPackagesResultData();	  
        $data['package_inquiry_count'] = count($this->inquiry_model->getPackageInquiryResultData(['i.agent_id'=>$this->session->userdata('id')]));	
        $data['hotel_inquiry_count'] = count($data['list'] = $this->inquiry_model->getInquiryResultData(['i.agent_id'=>$this->session->userdata('id')]));

        $hotel_pending_count = $this->model->countData('inquiries',['status'=>'pending']);
        $package_pending_count = $this->model->countData('package_inquiries',['status'=>'pending']);

		$data['pending_confirmation'] = $hotel_pending_count+$package_pending_count;	 
        $page = 'index';
        $this->header_and_footer($page, $data);
    }



    public function hotels()
    {
        $data['title'] = 'Hotels';

        $data['hotels'] = $this->website_model->get_all_hotels();

        $page = 'hotels';
        $this->header_and_footer($page, $data);
    }

    // Hotel details page
    public function hotel_details($property_id) {
        // Get hotel info
        $data['hotel'] = $this->website_model->get_hotel_by_id($property_id);

        // Get rooms for this hotel
        $data['rooms'] = $this->website_model->get_rooms_by_hotel($property_id);

        $data['title'] = $data['hotel']['name'] ?? 'Hotel Details';

        // Load header, footer and view
        $this->header_and_footer('hotel_details', $data);
    }


    public function inquiries() {
        $data['title'] = 'Inquiries';   
        $agent_id = $this->session->userdata('id');
		$data['list'] = $this->inquiry_model->getInquiryResultData(['i.agent_id'=>$agent_id]);	
		$data['package_inquiries'] = $this->inquiry_model->getPackageInquiryResultData(['i.agent_id'=>$agent_id]);			  
        $page = 'inquiries';
        $this->header_and_footer($page, $data);
    }

    public function packages() {
        $data['title'] = 'Packages';       
		$data['packages'] = $this->website_model->getPackagesResultData();	
        $page = 'packages';
        $this->header_and_footer($page, $data);
    }
public function package_details($id)
{
    $data['title'] = 'Package Details';

    // Get package by ID
    $data['package_data'] = $this->website_model->getPackageById($id);
    // echo "<pre>";print_r($data['package_data']);die();

    // Decode itinerary (multi-line string)
    $data['itinerary'] = $this->_parse_itinerary($data['package_data']['itinerary']);

    // Get inclusion list (if available)
    $data['inclusions'] = $data['package_data']['inclusions'] ?? [];


    // Get hotels (comma-separated list)
    $data['hotels'] = explode(",", trim($data['package_data']['hotels'] ?? ''));

    $page = 'package_details';
    $this->header_and_footer($page, $data);
}

// helper to parse itinerary into structured array
private function _parse_itinerary($itinerary_text)
{
   $lines = preg_split('/\r\n|\r|\n/', trim($itinerary_text ?? ''));

    $itinerary = [];
    $day = null;
    $desc = '';

    foreach ($lines as $line) {
        if (preg_match('/^Day\s*(\d+):\s*(.*)$/i', trim($line), $matches)) {
            if ($day !== null) {
                $itinerary[] = ['day' => $day, 'title' => $title, 'desc' => trim($desc)];
            }
            $day = $matches[1];
            $title = $matches[2];
            $desc = '';
        } else {
            $desc .= ' ' . trim($line);
        }
    }

    if ($day !== null) {
        $itinerary[] = ['day' => $day, 'title' => $title, 'desc' => trim($desc)];
    }

    return $itinerary;
}




    public function reports() {
        $data['title'] = 'Reports';       
        $page = 'reports';
        $this->header_and_footer($page, $data);
    }















    //Inquiry
    public function add_to_inquiry()
    {
        $agent_id = $this->session->userdata('id');
        $room_id  = $this->input->post('room_id');

        if(empty($room_id)) {
            echo json_encode(['return' => false, 'msg' => 'Invalid Room']);
            return;
        }

        // Check if room already added
        $exists = $this->model->getRowData('inquiry_cart',['agent_id'=>$agent_id,'room_id'=>$room_id]);
        if($exists) {
            echo json_encode(['return' => false, 'msg' => 'Room already added']);
            return;
        }

        // Add room to temporary inquiry
        $data = [
            'agent_id' => $agent_id,
            'room_id'  => $room_id,
            'price'  => get_current_month_prices('room', $room_id)[0],
        ];

        $insert_id = $this->model->add('inquiry_cart',$data);

        if($insert_id){
            // Get updated booking summary HTML
            // $rooms = $this->website_model->get_inquiry_cart($agent_id);
            $summary_html = $this->website_model->generate_booking_summary_html($agent_id);
            echo json_encode(['return' => true, 'summary_html' => $summary_html]);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Failed to add room']);
        }
    }

    public function get_booking_summary() {
        $agent_id = $this->session->userdata('id');
        $summary_html = $this->website_model->generate_booking_summary_html($agent_id);
        echo json_encode(['return' => true, 'summary_html' => $summary_html]);
    }

    public function remove_from_inquiry($cart_id){
        $agent_id = $this->session->userdata('id');
        $this->db->delete('inquiry_cart', ['id'=>$cart_id,'agent_id'=>$agent_id]);
        $summary_html = $this->website_model->generate_booking_summary_html($agent_id);
        echo json_encode(['return'=>true,'summary_html'=>$summary_html]);
    }

public function submit_inquiry() {
    $agent_id = $this->session->userdata('id');

    // Get all rooms from cart
    $cart_rooms = $this->website_model->get_inquiry_cart($agent_id);

    if(empty($cart_rooms)) {
        echo json_encode(['return'=>false,'msg'=>'No rooms in inquiry']);
        return;
    }

    // Calculate total amount
    $total_amount = 0;
    foreach($cart_rooms as $room){
        $total_amount += $room['price'];
    }

    // Insert into main inquiry table
    $inquiry_data = [
        'agent_id' => $agent_id,
        'status' => 'pending',
        'total_amount' => $total_amount
    ];
    if($this->model->add('inquiries', $inquiry_data)){
        $inquiry_id = $this->db->insert_id();
    }

    if(!$inquiry_id){
        echo json_encode(['return'=>false,'msg'=>'Failed to create inquiry']);
        return;
    }

    // Insert rooms into inquiry_rooms
    foreach($cart_rooms as $room){
        $this->model->add('inquiry_rooms', [
            'inquiry_id' => $inquiry_id,
            'room_id' => $room['room_id'],
            'price' => $room['price']
        ]);
    }

    // Clear cart
    $this->db->where('agent_id', $agent_id)->delete('inquiry_cart');

    echo json_encode(['return'=>true,'msg'=>'Inquiry submitted successfully']);
}









public function send_package_inquiry()
{
    $package_id = $this->input->post('package_id');
    $travel_date = $this->input->post('travel_date');
    $adults = $this->input->post('adults') ?? 1;
    $children = $this->input->post('children') ?? 1;
    $travelers = $this->input->post('travelers') ?? 1;
    $message = $this->input->post('message');
    $price = str_replace(',', '', $this->input->post('price'));
    $price = (float) $price; // optional, ensures it's numeric

    // Replace with logged-in agent ID
    $agent_id = $this->session->userdata('id') ?? 0;

    if(!$agent_id) {
        echo json_encode(['status'=>'error', 'message'=>'Please login first']);
        return;
    }

    if(!$package_id) {
        echo json_encode(['status'=>'error', 'message'=>'Invalid package']);
        return;
    }

    $data = [
        'agent_id' => $agent_id,
        'package_id' => $package_id,
        'travel_date' => $travel_date ?: null,
        'adults' => $adults,
        'children' => $children,
        'travelers' => $travelers,
        'message' => $message,
        'price' => $price,
        'status' => 'pending'
    ];


    if($this->model->add('package_inquiries',$data)){
        echo json_encode(['status'=>'success']);
    } else {
        echo json_encode(['status'=>'error', 'message'=>'Failed to save inquiry']);
    }
}


    
}
