<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Destination extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn()
    {
        // if ($this->session->userdata('role') !== 'admin' && $this->session->userdata('role') !== 'staff') {
        //     redirect(base_url('dashboard'));
        //     exit;
        // }
    }

    public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header', $data);
        $this->load->view('includes/sidebar', $data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }

    // =========================================
    // INDEX PAGE
    // =========================================
    public function index()
    {
        $data['title'] = 'Destinations';
        $page = 'destination/index';
        $this->header_and_footer($page, $data);
    }

    // =========================================
    // ADD DESTINATION
    // =========================================
    public function addDestination()
    {
        $countData = $this->model->countData('destinations', [
            'name' => $_POST['name']
        ]);

        if ($countData > 0) {
            echo json_encode(['return' => false, 'msg' => 'Destination already exists']);
            return;
        }

        $slug = strtolower(url_title($_POST['name']));

        $array = [
            'name'         => $_POST['name'],
            'slug'         => $slug,
            'description'  => $_POST['description'],
        ];

        if ($this->model->add('destinations', $array)) {
            $destination_id = $this->db->insert_id();

            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $destination_id,
                'add',
                'Destination'
            );

            echo json_encode(['return' => true, 'msg' => 'Destination Added Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Failed to add destination']);
        }
    }

    // =========================================
    // VIEW DESTINATIONS (TABLE LIST)
    // =========================================
    public function viewDestination()
    {
        $data['list'] = $this->model->getResultData('destinations', []); 
        $this->load->view('destination/tb', $data);
    }

    // =========================================
    // EDIT DESTINATION (FETCH DATA)
    // =========================================
    public function editDestination()
    {
        $data = $this->model->getRowData('destinations', ['id' => $_POST['id']]);

        $response = [
            'id'           => $data['id'],
            'name'         => $data['name'],
            'slug'         => $data['slug'],
            'description'  => $data['description'],
        ];

        echo json_encode($response);
    }

    // =========================================
    // UPDATE DESTINATION
    // =========================================
    public function updateDestination()
    {
        if (!isset($_POST['id']) || empty($_POST['id'])) {
            echo json_encode(['return' => false, 'msg' => 'Invalid Request']);
            return;
        }

        $id = $_POST['id'];

        $slug = strtolower(url_title($_POST['name']));

        $array = [
            'name'         => $_POST['name'],
            'slug'         => $slug,
            'description'  => $_POST['description'],
        ];

        if ($this->model->edit('destinations', $array, ['id' => $id])) {
            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $id,
                'edit',
                'Destination'
            );

            echo json_encode(['return' => true, 'msg' => 'Destination Updated Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Update Failed']);
        }
    }
}
