<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Agent extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('role') !== 'admin' && $this->session->userdata('role') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
	{
		$data['title'] = 'Agent';
		$data['roles'] = $this->model->getResultData('roles',['id!='=>'2','is_disable'=>0]);
		$data['agencies'] = $this->model->getResultData('agency',['is_disable'=>0]);
		$page = 'agent/index';
		$this->header_and_footer($page, $data);
	}
	
  
	public function addAgent()
    {
		$countData = $this->model->countData('users',['email'=>$_POST['email'],'mobile'=>$_POST['mobile']]);
		if($countData > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email/Mobile already exist']);
		}
		else
		{
			if(get_logged_user_type() == 'agency'){
				$agency_id = get_logged_agency()['id'];
			}else{
				$agency_id = $_POST['agency_id'];
			}
				
			$array = array(
				'agency_id' => $agency_id,
				'fullname' => $_POST['fullname'],
				'email' => $_POST['email'],
				'password' => md5($_POST['password']),
				'mobile' => $_POST['mobile'],
				'role_id' => $_POST['role_id'],
				'dob' => $_POST['dob'],
			);
			
			if($this->model->add('users',$array))
			{  
				$lead_id = $this->db->insert_id();
				$this->createLog($this->session->userdata('id'),$this->session->userdata('role'),$lead_id,'add','Agents');
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			} 
		}
		
    }
	public function viewAgent()
    {
		$data['list'] = $this->user_model->getUserResultData(['t1.id!='=>1]);		
		$this->load->view('agent/tb',$data);
    }
	public function editAgent()
    {
        $response=array();
		$data = $this->user_model->getUserRowData($_POST['id']);
		$response = array(
			'id' => $_POST['id'],
			'agency_id' => $data['agency_id'],
			'fullname' => $data['fullname'],
			'email' => $data['email'],
			'mobile' => $data['mobile'],
			'role_id' => $data['role_id'],
			'role_name' => $data['role_name'],
			'dob' => $data['dob'],
		);
		echo json_encode($response);
    }
	public function updateAgent()
    {
		$countData = $this->model->countData('users',['email'=>$_POST['email'],'mobile'=>$_POST['mobile'],'id!='=>$_POST['id']]);
		if($countData > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email/Mobile already exist']);
		}
		else
		{
			if(isset($_POST['id']))
			{
				if(get_logged_user_type() == 'agency'){
					$agency_id = get_logged_agency()['id'];
				}else{
					$agency_id = $_POST['agency_id'];
				}
				$array = array(
					'agency_id' => $agency_id,
					'fullname' => $_POST['fullname'],
					'email' => $_POST['email'],
					'mobile' => $_POST['mobile'],
					'role_id' => $_POST['role_id'],
					'dob' => $_POST['dob'],
				);
				
				if($this->model->edit('users',$array,['id'=>$_POST['id']]))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('role'),$lead_id,'edit','Agents master');					
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
		}
	}   	

	
	public function search_student()
    {
        echo get_students_json();
    }
	
}
