<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>B2B Travel Portal - Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

    <!-- jQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        .tab-active {
            border-bottom-color: #f97316;
            color: #f97316;
        }
    </style>

    <!-- ✅ Include SweetAlert2 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

</head>


<body class="bg-slate-50 text-slate-800">

    <!-- App Container -->
    <div class="min-h-screen flex flex-col">

        <!-- Header / Navbar -->
        <header class="bg-white shadow-sm sticky top-0 z-50">
            <div class="container mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex items-center justify-between h-16">
                    <!-- Logo -->
                    <div class="flex items-center space-x-2">
                        <!-- <svg class="h-8 w-8 text-sky-500" xmlns="http://www.w3.org/2000/svg" fill="none"
                            viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M12.75 3.03v.568c0 .334.148.65.405.864l1.068.89c.442.369.535 1.01.216 1.49l-.51.766a2.25 2.25 0 01-1.161.886l-.143.048a1.107 1.107 0 00-.57 1.664c.369.555.169 1.307-.427 1.605L9 13.125l.423 1.059a.956.956 0 01-1.652.928l-.679-.906a1.125 1.125 0 00-1.906.172L4.5 15.75l-.612.153M12.75 3.031a9 9 0 00-8.862 12.872M12.75 3.031a9 9 0 016.69 14.036m0 0l-.177.177a2.25 2.25 0 00-.998 1.787l-2.096 5.239a.75.75 0 001.123.82l5.239-2.096a2.25 2.25 0 001.787-.998l.177-.177M18 5.25a.75.75 0 00-1.06-1.06L15.75 5.25l1.19-1.192a.75.75 0 00-1.06-1.06l-1.192 1.19-1.192-1.19a.75.75 0 00-1.06 1.06l1.19 1.192-1.19 1.192a.75.75 0 001.06 1.06l1.192-1.19 1.192 1.19a.75.75 0 001.06-1.06L16.81 5.25l1.19-1.19z" />
                        </svg> -->
                        
                        <?php
                        $logo_path = !empty($agent['company_logo'])
                            ? base_url('assets/uploads/' . $agent['company_logo'])
                            : 'https://placehold.co/150x50/e0f2fe/0c4a6e?text=' . urlencode($agent['agency_name']);
                        ?>
                        <img src="<?= $logo_path ?>" alt="<?= $agent['agency_name']; ?> Logo"
                            class="h-10 w-auto object-contain">
                    </div>


                    <!-- Main Navigation -->
                    <?php $segment = $this->uri->segment(1); ?>

                    <nav class="hidden md:flex items-center space-x-6">
                        <a href="<?= base_url('agent-dashboard'); ?>" 
                        class="<?= ($segment == 'agent-dashboard') ? 'text-sky-600 font-semibold border-b-2 border-sky-600 pb-1' : 'text-slate-500 hover:text-sky-600 transition-colors' ?>">
                        Dashboard
                        </a>

                        <a href="<?= base_url('agency-inquiries'); ?>" 
                        class="<?= ($segment == 'agency-inquiries') ? 'text-sky-600 font-semibold border-b-2 border-sky-600 pb-1' : 'text-slate-500 hover:text-sky-600 transition-colors' ?>">
                        Inquiries
                        </a>

                        <a href="<?= base_url('hotels'); ?>" 
                        class="<?= ($segment == 'hotels') ? 'text-sky-600 font-semibold border-b-2 border-sky-600 pb-1' : 'text-slate-500 hover:text-sky-600 transition-colors' ?>">
                        Hotels
                        </a>

                        <a href="<?= base_url('packages'); ?>" 
                        class="<?= ($segment == 'packages') ? 'text-sky-600 font-semibold border-b-2 border-sky-600 pb-1' : 'text-slate-500 hover:text-sky-600 transition-colors' ?>">
                        Packages
                        </a>
                        <a href="<?= base_url('custom-packages'); ?>" 
                        class="<?= ($segment == 'custom-packages') ? 'text-sky-600 font-semibold border-b-2 border-sky-600 pb-1' : 'text-slate-500 hover:text-sky-600 transition-colors' ?>">
                        Custom Packages
                        </a>
                        <a href="<?= base_url('agent-profile'); ?>" 
                        class="<?= ($segment == 'agent-profile') ? 'text-sky-600 font-semibold border-b-2 border-sky-600 pb-1' : 'text-slate-500 hover:text-sky-600 transition-colors' ?>">
                        Profile
                        </a>


                        <!-- <a href="<?= base_url('reports'); ?>" 
                        class="<?= ($segment == 'reports') ? 'text-sky-600 font-semibold border-b-2 border-sky-600 pb-1' : 'text-slate-500 hover:text-sky-600 transition-colors' ?>">
                        Reports
                        </a> -->

                        <a href="<?= base_url('agent-logout'); ?>" 
                            onclick="return confirm('Are you sure you want to logout?');"
                            class="<?= ($segment == 'agent-logout') ? 'text-sky-600 font-semibold border-b-2 border-sky-600 pb-1' : 'text-slate-500 hover:text-sky-600 transition-colors' ?>">
                        Logout
                        </a>

                    </nav>


                    <!-- Profile & Actions -->
                    <!-- <div class="flex items-center space-x-4">
                        <button class="p-2 rounded-full text-slate-500 hover:bg-slate-100 hover:text-sky-600 transition-colors">
                           <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path></svg>
                        </button>
                        <div class="relative">
                            <img class="h-10 w-10 rounded-full object-cover" src="https://placehold.co/100x100/a3e635/44403c?text=AS" alt="Agent Profile">
                            <span class="absolute bottom-0 right-0 block h-2.5 w-2.5 rounded-full bg-green-400 ring-2 ring-white"></span>
                        </div>
                    </div> -->
                </div>
            </div>
        </header>
