<!-- Package Pricing (Grouped Date-wise) list table -->
<table class="table table-hover align-middle" id="pricingTable">
    <thead class="table-dark">
        <tr>
            <th>#</th>
            <th>Package</th>
            <th>Date-wise Prices</th>
            <th>Created</th>
            <th class="text-center">Action</th>
        </tr>
    </thead>
    <tbody>
        <?php 
        $i = 1; 
        foreach ($list as $val) { 
            $package = isset($val['package_name']) ? $val['package_name'] : '';
            $created = isset($val['created_at']) ? date('d M, Y', strtotime($val['created_at'])) : '-';
        ?>
        <tr>
            <td><?= $i++; ?></td>
            <td><i class="bi bi-box-seam me-1"></i><?= htmlspecialchars($package); ?></td>

            <td>
                <?php if (!empty($val['prices'])): ?>
                    <?php foreach ($val['prices'] as $p): ?>
                        <div class="mb-2">
                            <strong><?= htmlspecialchars($p['price_date_name']); ?></strong>
                            <small class="text-muted d-block">
                                <?= date('d M Y', strtotime($p['from_date'])); ?> → <?= date('d M Y', strtotime($p['to_date'])); ?>
                            </small>
                            <span class="badge bg-secondary mt-1">
                                ₹<?= number_format($p['price'], 2); ?>
                            </span>
                        </div>
                        <hr class="my-1">
                    <?php endforeach; ?>
                <?php else: ?>
                    <span class="text-muted">No prices found</span>
                <?php endif; ?>
            </td>

            <td><?= $created; ?></td>

            <td class="text-center">
                <a href="javascript:void(0)" class="btn btn-sm btn-outline-primary edit-btn"
                   onclick="editData(<?= $val['package_id']; ?>)" title="Edit">
                   <i class="bi bi-pencil-square"></i>
                </a>
            </td>
        </tr>
        <?php } ?>
    </tbody>
</table>

<!-- JS: DataTables init and tooltips -->
<script>
$(document).ready(function () {
    // Bootstrap tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    tooltipTriggerList.map(function (el) { return new bootstrap.Tooltip(el); });

    const isAdmin = $('#usertype').val() === 'admin';

    $('#pricingTable').DataTable({
        dom: isAdmin ? 'Bfrtip' : 'frtip',
        aaSorting: [[0, 'asc']],
        pageLength: 25,
        columnDefs: [
            { orderable: false, targets: -1 } // disable sorting on Action column
        ],
        buttons: isAdmin ? [
            { extend: 'excel', className: 'btn btn-sm btn-success', text: '<i class="bi bi-file-earmark-excel"></i> Excel', exportOptions: { columns: [0,1,2,3] } },
            { extend: 'csv',  className: 'btn btn-sm btn-primary', text: '<i class="bi bi-filetype-csv"></i> CSV', exportOptions: { columns: [0,1,2,3] } },
            { extend: 'pdf',  className: 'btn btn-sm btn-danger', text: '<i class="bi bi-file-earmark-pdf"></i> PDF', exportOptions: { columns: [0,1,2,3] } }
        ] : []
    });

    // Hide edit/add for staff
    if ($('#usertype').val() === 'staff') {
        $('.edit-btn').remove();
        $('.add-btn').remove();
    }
});
</script>
