<script>
$(document).ready(function() {
    $('#roomTable').DataTable({
        "processing": true,      // show processing indicator
        "serverSide": false,     // set to true if you want server-side processing
        "paging": true,
        "searching": true,
        "ordering": true,
        "order": [[0, "asc"]],   // default order by first column
        "lengthMenu": [10, 25, 50, 100],
        "language": {
            "search": "Filter records:",
            "lengthMenu": "Show _MENU_ entries",
            "info": "Showing _START_ to _END_ of _TOTAL_ entries",
            "infoEmpty": "No records available",
            "emptyTable": "No amenities found",
        }
    });
});
</script>

<!-- list table -->
<table class="table table-hover align-middle" id="packageTable">
  <thead class="table-dark">
    <tr>
      <th>#</th>
      <th>Destination</th>
      <th>Title</th>
      <th>Duration</th>
      <th>Short Description</th>
      <th>Image</th>
      <th>Created</th>
      <th class="text-center">Action</th>
    </tr>
  </thead>
  <tbody>
    <?php $i = 1; foreach ($list as $val) { 
      $destination = isset($val['destination_name']) ? $val['destination_name'] : '';
      $title       = isset($val['title']) ? $val['title'] : '';
      $short_desc  = isset($val['short_description']) ? $val['short_description'] : '';
      $short       = mb_strlen($short_desc) > 80 ? mb_substr($short_desc, 0, 80).'...' : $short_desc;
      $nights      = isset($val['duration_nights']) ? $val['duration_nights'] : 0;
      $days        = isset($val['duration_days']) ? $val['duration_days'] : 0;
      $image       = isset($val['image']) ? $val['image'] : '';
      $created     = isset($val['created_at']) ? $val['created_at'] : (isset($val['created']) ? $val['created'] : '');
      $is_disable  = isset($val['is_disable']) ? $val['is_disable'] : 0;
    ?>
    <tr>
      <td><?= $i++; ?></td>

      <td>
        <i class="bi bi-geo-alt-fill me-1"></i>
        <?= htmlspecialchars($destination); ?>
      </td>

      <td><?= htmlspecialchars($title); ?></td>

      <td>
        <?= $nights . "N / " . $days . "D"; ?>
      </td>


      <td>
        <div 
          data-bs-toggle="tooltip" 
          data-bs-placement="top"
          title="<?= htmlspecialchars($short_desc); ?>">
          <?= htmlspecialchars($short); ?>
        </div>
      </td>

      <td>
        <?php if (!empty($image)) { ?>
          <!-- <img src="<?= base_url('assets/uploads/' . $image); ?>" alt="Package Image" class="img-thumbnail" style="width:60px; height:60px; object-fit:cover;"> -->
        <?php } else { ?>
          <!-- <span class="text-muted">No Image</span> -->
        <?php } ?>
        <a href="javascript:void(0)" class="btn btn-primary btn-sm edit-btn"  onclick="packageImage(<?= $val['id']; ?>)" data-bs-toggle="modal" data-bs-target="#packageImageModal" data-bs-original-title="Package Image">View</a>
      </td>

      <td><?= ($created) ? date('d M, Y', strtotime($created)) : '-'; ?></td>

      <td class="text-center">
        <a href="javascript:void(0)" 
           class="btn btn-sm btn-outline-primary edit-btn"
           onclick="editData(<?= $val['id']; ?>)" 
           title="Edit">
           <i class="bi bi-pencil-square"></i>
        </a>

        <?php if ($is_disable == '0') { ?>
            <a href="javascript:void(0)" class="btn btn-sm btn-outline-danger"
                onclick="changeStatus(<?= $val['id']; ?>, '1')" title="Disable">
                <i class="bi bi-x-circle"></i>
            </a>
        <?php } else { ?>
            <a href="javascript:void(0)" class="btn btn-sm btn-outline-success"
                onclick="changeStatus(<?= $val['id']; ?>, '0')" title="Enable">
                <i class="bi bi-check-circle"></i>
            </a>
        <?php } ?>
        <a href="javascript:void(0)" 
            class="btn btn-danger btn-sm"
            onclick="deleteRecord(<?= $val['id']; ?>, 'packages')">
            Delete
        </a>
      </td>
    </tr>
    <?php } ?>
  </tbody>
</table>



<!-- JS: DataTables init, tooltips and changeStatus -->
<script>


function changeStatus(id, newStatus) {
    if (!confirm('Are you sure you want to change status?')) return;

    $.ajax({
        url: "<?= base_url('Dashboard/Status'); ?>",
        method: "POST",
        data: {
            id: id,
            type: newStatus,            // send desired status string 'available' / 'unavailable'
            table: 'packages',
            column: 'is_disable',
            module: 'packages'
        },
        dataType: 'json',
        success: function(res) {
            if (res.return) {
                // reload listing area
                $("#tb").load("<?= base_url('package/viewPackage'); ?>");
                toastr.success(res.msg);
            } else {
                toastr.error(res.msg);
            }
        },
        error: function() {
            toastr.error('Server error. Try again.');
        }
    });
}
</script>
