<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Roles extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        $this->hasPermission();
    }
    public function hasPermission()
	{
        if (!has_permission('role_access'))
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
	{
		$data['title'] = 'Roles';
		
		$page = 'roles/index';
		$this->header_and_footer($page, $data);
	}
	
  
	public function addRole()
    {
		$countData = $this->model->countData('roles',['role_name'=>$_POST['role_name']]);
		if($countData > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Role already exist']);
		}
		else
		{
			$array = array(
				'role_name' => $_POST['role_name'],
			);
			
			if($this->model->add('roles',$array))
			{  
				$lead_id = $this->db->insert_id();
				$this->createLog($this->session->userdata('id'),$this->session->userdata('role'),$lead_id,'add','Roles');
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			} 
		}
		
    }
	public function viewRole()
    {
		$data['list'] = $this->model->getResultData('roles',[]);
		$this->load->view('roles/tb',$data);
    }
	public function editRole()
    {
        $response=array();
		$data = $this->model->getRowData('roles',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'role_name' => $data['role_name'],
		);
		echo json_encode($response);
    }
	public function updateRole()
    {
		$countData = $this->model->countData('roles',['role_name'=>$_POST['role_name'],'id!='=>$_POST['id']]);
		if($countData > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Role already exist']);
		}
		else
		{
			if(isset($_POST['id']))
			{
				$array = array(
					'role_name' => $_POST['role_name'],
				);
				
				if($this->model->edit('roles',$array,['id'=>$_POST['id']]))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('role'),$lead_id,'edit','Roles master');					
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
		}
	}   	
}
