<?php
$agent_id = $this->session->userdata('id');
$added_rooms = $this->website_model->get_inquiry_cart($agent_id); // returns array of rooms
$added_room_ids = array_column($added_rooms, 'room_id');
?>

<style>
    body {
        font-family: 'Inter', sans-serif;
    }

    .tab-active {
        border-bottom-color: #0ea5e9;
        /* sky-500 */
        color: #0284c7;
        /* sky-600 */
        font-weight: 600;
    }
</style>

<main class="flex-grow">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-10">
        <!-- Hotel Header -->
        <div class="mb-6">
            <h1 class="text-4xl font-bold text-slate-800"><?= $hotel['name']; ?></h1>
            <div class="flex items-center mt-2">
                <span class="text-yellow-400">★★★★☆</span>
                <p class="text-sm text-slate-500 ml-3"><?= $hotel['address']; ?>, <?= $hotel['city']; ?></p>
            </div>
        </div>

        <!-- Image Gallery (Static Images) -->
        <!-- <div class="grid grid-cols-4 grid-rows-2 gap-2 mb-8 h-96">
            <div class="col-span-2 row-span-2">
                <img src="https://placehold.co/800x600/0ea5e9/ffffff?text=Main+View" alt="Main hotel view" class="w-full h-full object-cover rounded-lg">
            </div>
            <div><img src="https://placehold.co/400x300/38bdf8/ffffff?text=Lobby" alt="Lobby" class="w-full h-full object-cover rounded-lg"></div>
            <div><img src="https://placehold.co/400x300/7dd3fc/ffffff?text=Pool" alt="Pool" class="w-full h-full object-cover rounded-lg"></div>
            <div><img src="https://placehold.co/400x300/bae6fd/ffffff?text=Restaurant" alt="Restaurant" class="w-full h-full object-cover rounded-lg"></div>
            <div class="relative">
                <img src="https://placehold.co/400x300/e0f2fe/ffffff?text=Suite" alt="Suite" class="w-full h-full object-cover rounded-lg">
                <div class="absolute inset-0 bg-black bg-opacity-50 flex items-center justify-center rounded-lg">
                    <button class="text-white font-semibold text-sm bg-black bg-opacity-50 px-4 py-2 rounded-md border border-white hover:bg-opacity-75">View All Photos</button>
                </div>
            </div>
        </div> -->

        <!-- Main Section with Sidebar -->
        <div class="flex flex-col lg:flex-row gap-8">
            <!-- Left Column: Hotel Info & Rooms -->
            <div class="w-full lg:w-2/3">
                <!-- Info Tabs -->
                <div class="border-b border-slate-200 mb-6">
                    <nav class="-mb-px flex space-x-8" aria-label="Tabs">
                        <a href="#"
                            class="border-transparent text-slate-500 hover:text-slate-700 hover:border-slate-300 whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm tab-active">Available
                            Rooms</a>
                    </nav>
                </div>

                <!-- Room List -->
                <div class="space-y-6">
                    <?php foreach ($rooms as $room): ?>
                        <div
                            class="bg-white rounded-lg shadow-md border border-slate-200 overflow-hidden hover:shadow-xl transition-shadow">
                            <div class="flex flex-col sm:flex-row">
                                <!-- Room Image -->
                                <div class="sm:w-1/3">
                                    <?php
                                    $room_image = !empty($room['image']) && file_exists(FCPATH . 'assets/uploads/' . $room['image'])
                                        ? base_url('assets/uploads/' . $room['image'])
                                        : base_url('assets/img/default-room.png');
                                    ?>
                                    <img src="<?= $room_image; ?>" alt="<?= $room['name']; ?>"
                                        class="w-full h-full object-cover">

                                </div>

                                <!-- Room Info -->
                                <div class="p-4 sm:w-2/3 flex flex-col justify-between">
                                    <div>
                                        <h3 class="text-xl font-bold text-slate-800"><?= $room['name']; ?></h3>
                                        <p class="text-sm text-slate-600 mt-1"><?= $room['description']; ?></p>

                                        <!-- Capacity & Bed Type -->
                                        <div class="flex items-center space-x-4 text-sm text-slate-500 mt-2">
                                            <span>👥 <?= $room['capacity']; ?> People</span>
                                            <span>•</span>
                                            <span>🛏 <?= ucfirst($room['bed_type']); ?></span>
                                            <span>•</span>
                                            <span>📐 <?= $room['size_sqft']; ?> sqft</span>
                                        </div>

                                        <!-- Room Amenities -->
                                        <?php if (!empty($room['amenities'])): ?>
                                            <div class="flex flex-wrap mt-3 gap-2 text-green-600 text-sm">
                                                <?php
                                                $amenities = explode(',', $room['amenities']);
                                                foreach ($amenities as $amenity):
                                                    ?>
                                                    <span class="flex items-center gap-1">
                                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                                d="M5 13l4 4L19 7"></path>
                                                        </svg>
                                                        <?= $amenity; ?>
                                                    </span>
                                                <?php endforeach; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>

                                    <!-- Price & Book Button -->
                                    <div class="bg-slate-50 p-4 mt-4 sm:mt-auto border-t flex justify-between items-center">
                                        <div>
                                            <!-- <p class="text-lg font-bold text-orange-600">₹<?=
                                                get_lowest_price('room', $room['id'])['price_with_markup']; ?></p> -->


                                            <?php
                                            if (!isset($_POST['checkin']) || empty($_POST['checkin'])) {
                                                $price = get_current_month_prices('room', $room['id'])['markup_prices'][0];
                                            } else {
                                                $price = get_price_by_travel_date('room', $room['id'], $_POST['checkin'])['price_with_markup'];
                                            }
                                            ?>
                                            <p class="text-lg font-bold text-orange-600">₹<?= $price; ?></p>


                                            <p class="text-xs text-slate-500">per night</p>
                                        </div>
                                        <?php if (!in_array($room['id'], $added_room_ids)): ?>
                                            <button id="add-btn-<?= $room['id']; ?>"
                                                class="add-to-inquiry bg-orange-500 text-white font-bold py-2 px-4 rounded-md hover:bg-orange-600 transition-colors"
                                                data-room-id="<?= $room['id']; ?>">
                                                Add to Inquiry
                                            </button>
                                            <button id="added-btn-<?= $room['id']; ?>" disabled
                                                class="bg-gray-400 text-white font-bold py-2 px-4 rounded-md cursor-not-allowed"
                                                style="display:none">
                                                Added
                                            </button>
                                        <?php else: ?>
                                            <button id="added-btn-<?= $room['id']; ?>" disabled
                                                class="bg-gray-400 text-white font-bold py-2 px-4 rounded-md cursor-not-allowed">
                                                Added
                                            </button>
                                        <?php endif; ?>


                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

            </div>

            <!-- Right Column: Booking Summary -->
            <aside class="w-full lg:w-1/3">
                <div class="sticky top-24">
                    <div id="booking-summary" class="bg-white p-6 rounded-lg shadow-md border border-slate-200">
                        <!-- Booking summary will be dynamically injected here -->
                    </div>
                </div>
            </aside>

        </div>
    </div>
</main>




<script>

    $(document).ready(function () {
        loadBookingSummary(); // load summary on page load

        function loadBookingSummary() {
            $.ajax({
                url: "<?= base_url('website/get_booking_summary'); ?>",
                method: "POST",
                dataType: 'json',
                success: function (res) {
                    if (res.return) {
                        $('#booking-summary').html(res.summary_html);
                    } else {
                        $('#booking-summary').html('<p class="text-center text-gray-500">No rooms added yet.</p>');
                    }
                }
            });
        }
    });
    $('.add-to-inquiry').click(function () {
        let room_id = $(this).data('room-id');

        $.ajax({
            url: "<?= base_url('website/add_to_inquiry'); ?>",
            method: "POST",
            data: { room_id: room_id },
            dataType: 'json',
            success: function (res) {
                if (res.return) {
                    // Update booking summary on right side
                    $('#booking-summary').html(res.summary_html);
                    $('#add-btn-' + room_id).hide();
                    $('#added-btn-' + room_id).show();


                    toastr.success('Room added to inquiry');
                } else {
                    toastr.error(res.msg);
                }
            }
        });
    });


    function removeFromInquiry(cart_id, room_id) {
        if (!confirm('Are you sure you want to remove this room?')) return;

        $.ajax({
            url: "<?= base_url('website/remove_from_inquiry'); ?>/" + cart_id,
            method: "GET",
            dataType: "json",
            success: function (res) {
                if (res.return) {
                    // Update booking summary
                    $('#booking-summary').html(res.summary_html);

                    // Re-enable the Add button for this room
                    $('#added-btn-' + room_id).hide();
                    $('#add-btn-' + room_id).show();
                } else {
                    alert('Failed to remove room');
                }
            }
        });
    }


    function submitInquiry() {
        if (!confirm('Are you sure you want to submit this inquiry?')) return;

        $.ajax({
            url: "<?= base_url('website/submit_inquiry'); ?>",
            method: "POST",
            dataType: "json",
            success: function (res) {
                if (res.return) {


                    alert(res.msg);
                    location.reload();
                } else {
                    alert(res.msg);
                }
            }
        });
    }

</script>