<?php
    $logo_path = !empty($agent['company_logo'])
    ? base_url('assets/uploads/' . $agent['company_logo'])
    : 'https://placehold.co/150x50/e0f2fe/0c4a6e?text=' . urlencode($agent['agency_name']);
    // echo $logo_path;die();
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Custom Inquiry - <?= htmlspecialchars($inquiry['package_name']) ?></title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            padding: 20px;
        }
        .header {
            border-bottom: 2px solid #333;
            padding-bottom: 8px;
            margin-bottom: 20px;
        }
        .header img {
            height: 50px;
            vertical-align: middle;
        }
        .header h2 {
            display: inline-block;
            margin-left: 15px;
            vertical-align: middle;
            color: #222;
        }
        .section-title {
            background: #f4f4f4;
            padding: 8px;
            font-weight: bold;
            border-left: 4px solid #007bff;
            margin-top: 25px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 8px;
        }
        table th, table td {
            border: 1px solid #ccc;
            padding: 6px 8px;
            text-align: left;
        }
        table th {
            background: #eaeaea;
        }
        .summary {
            text-align: right;
            margin-top: 20px;
        }
        .summary table {
            width: 250px;
            float: right;
            border: none;
        }
        .summary td {
            padding: 6px;
            border: none;
        }
        .summary .label {
            text-align: left;
            font-weight: bold;
        }
        .footer {
            border-top: 1px solid #ccc;
            margin-top: 50px;
            padding-top: 10px;
            font-size: 11px;
            color: #777;
            text-align: center;
        }
    </style>
</head>
<body>
<div class="container">

    <!-- HEADER -->


    <div class="header" style="text-align:center; margin-bottom:20px;">
        <img src="<?= $logo_path ?>" alt="Logo" style="max-height:70px; margin-bottom:8px;">
        <h2 style="margin:5px 0 0; font-size:20px; color:#333;">Custom Package Inquiry</h2>
    </div>




    <!-- PACKAGE DETAILS -->
    <div class="section-title">Package Details</div>
    <table>
        <tr><th>Package Name</th><td><?= htmlspecialchars($inquiry['package_name']) ?></td></tr>
        <tr><th>Destination</th><td><?= htmlspecialchars($inquiry['destination_name']) ?></td></tr>
        <tr><th>Travel Dates</th><td><?= date('d M Y', strtotime($inquiry['start_date'])) ?> → <?= date('d M Y', strtotime($inquiry['end_date'])) ?></td></tr>
        <tr><th>Total Days</th><td><?= $inquiry['no_of_days'] ?></td></tr>
        <tr><th>Adults</th><td><?= $inquiry['no_of_adults'] ?></td></tr>
        <tr><th>Children</th><td><?= $inquiry['no_of_children'] ?></td></tr>
    </table>

    <!-- CUSTOMER DETAILS -->
    <div class="section-title">Agent Details</div>
    <table>
        <tr><th>Name</th><td><?= htmlspecialchars($inquiry['agent_name']) ?></td></tr>
        <tr><th>Email</th><td><?= htmlspecialchars($inquiry['email']) ?></td></tr>
        <tr><th>Phone</th><td><?= htmlspecialchars($inquiry['mobile']) ?></td></tr>
        <tr><th>Inquiry Date</th><td><?= date('d M Y', strtotime($inquiry['created_at'])) ?></td></tr>
        <tr><th>Status</th><td style="text-transform:capitalize;"><?= htmlspecialchars($inquiry['status']) ?></td></tr>
    </table>

    <!-- ITINERARY DETAILS -->
    <div class="section-title">Itinerary Details</div>
    <table>
        <thead>
            <tr>
                <th>Day</th>
                <th>City</th>
                <th>Hotel</th>
                <th>Room Type</th>
                <!-- <th>Price / Night (₹)</th> -->
                <th>Nights</th>
                <!-- <th>Total (₹)</th> -->
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($inquiry['items'])): ?>
                <?php foreach ($inquiry['items'] as $item): ?>
                    <tr>
                        <td><?= $item['day_no'] ?></td>
                        <td><?= htmlspecialchars($item['city_name']) ?></td>
                        <td><?= htmlspecialchars($item['hotel_name']) ?></td>
                        <td><?= htmlspecialchars($item['room_name']) ?></td>
                        <!-- <td><?= number_format($item['price_per_night'], 2) ?></td> -->
                        <td><?= $item['nights'] ?></td>
                        <!-- <td><?= number_format($item['total_price'], 2) ?></td> -->
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr><td colspan="7" align="center">No itinerary data available</td></tr>
            <?php endif; ?>
        </tbody>
    </table>

    <!-- TOTAL SUMMARY -->
    <div class="summary">
        <table>
            <tr>
                <td class="label">Subtotal:</td>
                <td>₹ <?= number_format($inquiry['subtotal'], 2) ?></td>
            </tr>
            <tr>
                <td class="label">Grand Total:</td>
                <td><strong>₹ <?= number_format($inquiry['total'], 2) ?></strong></td>
            </tr>
        </table>
    </div>

    <!-- FOOTER -->
    <div class="footer">
       
    </div>

</div>
</body>
</html>
