<script>
    $(document).ready(function() {
      if($('#usertype').val() == 'admin'){
        $('#mytable').DataTable({
          dom: 'Bfrtip',
          aaSorting: [[0, 'desc']],
        buttons: [
        //  { extend: 'pdf', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3, 4]}, },
          //{ extend: 'excel', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3, 4]}, },
         // { extend: 'csv', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3, 4]}, },
        ]
        });
      }else{
        $('#mytable').DataTable({
          aaSorting: [[0, 'desc']],
        });
      }
        if($('#usertype').val() == 'staff')
        {
            $('.edit-btn').remove();
            $('.add-btn').remove();
        }
    } );
</script>
<table class="table table-striped table-hover" id="mytable">
    <thead>
      <tr>
          <th scope="col">S.No.</th>
          <th scope="col">Role name</th>
          <th scope="col">Date</th>
          <th scope="col">Action</th>
      </tr>
    </thead>
    <tbody>
      <?php $i=1; foreach($list as $val) { ?>
      <tr>
        <th scope="row"><?= $val['id']; ?></th>
        <td><?= $val['role_name']; ?></td>
        <td><?= date('d-m-Y',strtotime($val['created']));?></td>
        <td>
          <?php if (has_permission('role_edit')): ?>
            <a href="javascript:void(0)" class="btn btn-info btn-sm edit-btn" onclick="editData(<?= $val['id']; ?>)" data-bs-toggle="modal" data-bs-target="#editModal">Edit</a>
          <?php endif; ?>

          <?php if (has_permission('role_disable')): ?>
            <?php if($val['is_disable'] == '0'){ ?>
                <a href="javascript:void(0)" class="btn btn-danger btn-sm disable-btn disable-btn" onclick="changeStatus(<?= $val['id']; ?>,'1')">Disable</a>
            <?php } else{ ?>
                <a href="javascript:void(0)" class="btn btn-success btn-sm disable-btn disable-btn" onclick="changeStatus(<?= $val['id']; ?>,'0')">Enable</a>
            <?php } ?> 
          <?php endif; ?>
        </td>
      </tr>
      <?php } ?>
    </tbody>
</table>
<script>
function changeStatus(id,type)
{
  if (confirm('Are you sure?') == true) {
    var table = 'roles';
    var column = 'is_disable';
    $.ajax({
        url: "<?= base_url('Dashboard/Status'); ?>",
        method: "POST",
        data: {
            id:id,
            type:type,
            table:table,
            column:column,
            module:'role'
        },
        dataType:'json',
        success:function(res){
          if(res.return)
          {
            $("#tb").load("<?= base_url('roles/viewRole/') ?>")
            toastr.success(res.msg);
          }
          else
          {          
            toastr.error(res.msg);
          }
        }
    });
  }
};
</script>