<!-- Room list table -->
<table class="table table-hover align-middle" id="roomTable">
    <thead class="table-dark">
        <tr>
            <th>#</th>
            <th>Property</th>
            <th>Room Name</th>
            <th>Description</th>
            <th>Capacity</th>
            <th>Bed Type</th>
            <th>Size (sqft)</th>
            <th>Status</th>
            <th>Created</th>
            <th class="text-center">Action</th>
        </tr>
    </thead>
    <tbody>
        <?php $i = 1; foreach($list as $val) { 
            // safe values & description preview
            $property = isset($val['property_name']) ? $val['property_name'] : '';
            $name     = isset($val['name']) ? $val['name'] : '';
            $desc     = isset($val['description']) ? $val['description'] : '';
            $short    = mb_strlen($desc) > 80 ? mb_substr($desc, 0, 80).'...' : $desc;
            $capacity = isset($val['capacity']) ? (int)$val['capacity'] : '';
            $bed_type = isset($val['bed_type']) ? $val['bed_type'] : '';
            $size     = isset($val['size_sqft']) ? $val['size_sqft'] : '';
            $status   = isset($val['status']) ? $val['status'] : 'unavailable';
            // created_at fallback
            $created  = isset($val['created_at']) ? $val['created_at'] : (isset($val['created']) ? $val['created'] : '');
        ?>
        <tr>
            <td><?= $i++; ?></td>

            <td>
                <i class="bi bi-building-fill me-1"></i>
                <?= htmlspecialchars($property); ?>
            </td>

            <td><?= htmlspecialchars($name); ?></td>

            <td>
                <div 
                  data-bs-toggle="tooltip" 
                  data-bs-placement="top"
                  title="<?= htmlspecialchars($desc); ?>">
                  <?= htmlspecialchars($short); ?>
                </div>
            </td>

            <td><?= $capacity; ?></td>

            <td>
                <span class="badge bg-info text-uppercase"><?= htmlspecialchars($bed_type); ?></span>
            </td>

            <td><?= htmlspecialchars($size); ?></td>

            <td>
                <?php if ($status === 'available') { ?>
                    <span class="badge bg-success">Available</span>
                <?php } else { ?>
                    <span class="badge bg-secondary">Unavailable</span>
                <?php } ?>
            </td>

            <td>
                <?= ($created) ? date('d M, Y', strtotime($created)) : '-'; ?>
            </td>

            <td class="text-center">
                <a href="javascript:void(0)" class="btn btn-sm btn-outline-primary edit-btn"
                   onclick="editData(<?= $val['id']; ?>)" title="Edit">
                   <i class="bi bi-pencil-square"></i>
                </a>

                <?php if ($status === 'available') { ?>
                    <a href="javascript:void(0)" class="btn btn-sm btn-outline-danger"
                       onclick="changeStatus(<?= $val['id']; ?>, 'unavailable')" title="Mark Unavailable">
                       <i class="bi bi-x-circle"></i>
                    </a>
                <?php } else { ?>
                    <a href="javascript:void(0)" class="btn btn-sm btn-outline-success"
                       onclick="changeStatus(<?= $val['id']; ?>, 'available')" title="Mark Available">
                       <i class="bi bi-check-circle"></i>
                    </a>
                <?php } ?>
            </td>
        </tr>
        <?php } ?>
    </tbody>
</table>

<!-- JS: DataTables init, tooltips and changeStatus -->
<script>
$(document).ready(function () {
    // initialize bootstrap tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    tooltipTriggerList.map(function (el) { return new bootstrap.Tooltip(el) })

    const isAdmin = $('#usertype').val() === 'admin';

    $('#roomTable').DataTable({
        dom: isAdmin ? 'Bfrtip' : 't',
        aaSorting: [[0, 'desc']],
        pageLength: 25,
        columnDefs: [
            { orderable: false, targets: -1 } // disable sorting on Action column
        ],
        buttons: isAdmin ? [
            { extend: 'excel', className: 'btn btn-sm btn-success', text: '<i class="bi bi-file-earmark-excel"></i> Excel', exportOptions: { columns: [0,1,2,3,4,5,6,7,8] } },
            { extend: 'csv',  className: 'btn btn-sm btn-primary', text: '<i class="bi bi-filetype-csv"></i> CSV', exportOptions: { columns: [0,1,2,3,4,5,6,7,8] } },
            { extend: 'pdf',  className: 'btn btn-sm btn-danger', text: '<i class="bi bi-file-earmark-pdf"></i> PDF', exportOptions: { columns: [0,1,2,3,4,5,6,7,8] } }
        ] : []
    });

    // hide edit/add for staff
    if ($('#usertype').val() === 'staff') {
        $('.edit-btn').remove();
        $('.add-btn').remove();
    }
});

function changeStatus(id, newStatus) {
    if (!confirm('Are you sure you want to change status?')) return;

    $.ajax({
        url: "<?= base_url('Dashboard/Status'); ?>",
        method: "POST",
        data: {
            id: id,
            type: newStatus,            // send desired status string 'available' / 'unavailable'
            table: 'rooms',
            column: 'status',
            module: 'room'
        },
        dataType: 'json',
        success: function(res) {
            if (res.return) {
                // reload listing area
                $("#tb").load("<?= base_url('room/viewRoom'); ?>");
                toastr.success(res.msg);
            } else {
                toastr.error(res.msg);
            }
        },
        error: function() {
            toastr.error('Server error. Try again.');
        }
    });
}
</script>
