<?php


class Property_model extends CI_Model
{
    public function getPropertyRowData($id)
    {
        $this->db
            ->select('t1.*, 
                  t2.name as country_name,
                  t3.name as state_name,
                  t4.name as city_name,')
            ->from('properties t1')
            ->join('countries t2', 't2.id = t1.country', 'left')
            ->join('states t3', 't3.id = t1.state', 'left')
            ->join('cities t4', 't4.id = t1.city', 'left')
            ->where('t1.id', $id);


        $query = $this->db->get();




        return $query->row_array();
    }
    public function getPropertyResultData($where = null, $search = null)
    {
        $this->db
            ->select('t1.*, 
                  t2.name as country_name,
                  t3.name as state_name,
                  t4.name as city_name,')
            ->from('properties t1')
            ->join('countries t2', 't2.id = t1.country', 'left')
            ->join('states t3', 't3.id = t1.state', 'left')
            ->join('cities t4', 't4.id = t1.city', 'left')
            ->order_by('t1.created', 'DESC');

        if (isset($where) && $where !== null) {
            foreach ($where as $key => $val) {
                $this->db->where($key, $val);
            }
        }
        if (!empty($search)) {
            $this->db->group_start()
                ->like('t1.name', $search)
                ->or_like('t3.name', $search)
                ->or_like('t4.name', $search)
                ->group_end();
        }

        $query = $this->db->get();
        return $query->result_array();
    }
    public function getPropertyAmenitiesResultData()
    {
        $this->db
            ->select('t1.*, 
                  t2.name as property_name')
            ->from('property_amenities t1')
            ->join('properties t2', 't2.id = t1.property_id', 'left');

        $query = $this->db->get();
        return $query->result_array();
    }
    public function getPropertyPoliciesResultData()
    {
        $this->db
            ->select('t1.*, 
                  t2.name as property_name')
            ->from('property_policies t1')
            ->join('properties t2', 't2.id = t1.property_id', 'left');

        $query = $this->db->get();
        return $query->result_array();
    }




    //property image
    public function propertyImage($property_id)
    {
        $images = $this->db->get_where('property_image', ['property_id' => $property_id])->result_array();
        $data = '';
        $i = 1;
        foreach ($images as $image) {
            $ext = substr($image['image'], strrpos($image['image'], '.') + 1);
            $data .= '<tr>';
            $data .= '<td>' . $i++ . '</td>';

            if ($ext == 'mp4' || $ext == 'mov') {
                $data .= '<td><iframe src="' . base_url('assets/uploads/' . $image['image']) . '" height="80" width="100"></iframe></td>';
            } else {
                $data .= '<td><img src="' . base_url('assets/uploads/' . $image['image']) . '" height="70"></td>';
            }

            $data .= '<td>';
            if ($image['is_cover'] !== '1') {
                $data .= '<button class="btn btn-sm btn-danger" onclick="deletePropertyImage(' . $image['id'] . ',' . $property_id . ')">Delete</button>';
            } else {
                $data .= '<button class="btn btn-sm btn-danger" onclick="propertyDeleteAlert()">Delete</button>';
            }
            if ($image['is_cover'] !== '1') {
                $data .= '<button class="btn btn-sm btn-primary" onclick="makePropertyCoverImage(' . $image['id'] . ',' . $property_id . ')">Make cover</button>';
            }
            $data .= '</td>';
            $data .= '</tr>';
        }
        echo $data;
    }
}

?>