<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Package_model extends CI_Model {

    public function __construct()
    {
        parent::__construct();
    }

    // Get all packages
    public function get_all_packages()
    {
        $this->db->select('p.*, d.name as destination_name');
        $this->db->from('packages p');
        $this->db->join('destinations d', 'd.id = p.destination_id', 'left');
        $this->db->where('p.is_disable', 0);
        $query = $this->db->get();
        return $query->result_array();
    }

    // Check duplicate field (package_code)
    public function check_duplicate($field, $value, $exclude_id = null)
    {
        $this->db->where($field, $value);
        if ($exclude_id) {
            $this->db->where('id !=', $exclude_id);
        }
        $this->db->where('is_disable', 0);
        return $this->db->count_all_results('packages');
    }

    // Insert new package
    public function insert_package($data)
    {
        $array = [
            'destination_id' => $data['destination_id'],
            'package_name'   => $data['package_name'],
            'package_code'   => $data['package_code'],
            'nights'         => $data['nights'],
            'days'           => $data['days'],
            'price'          => $data['price'],
            'created'        => date('Y-m-d H:i:s'),
            'updated'        => date('Y-m-d H:i:s'),
        ];

        $this->db->insert('packages', $array);
        return $this->db->insert_id();
    }

    // Get package by ID
    public function get_package($id)
    {
        $this->db->select('p.*, d.name as destination_name');
        $this->db->from('packages p');
        $this->db->join('destinations d', 'd.id = p.destination_id', 'left');
        $this->db->where('p.id', $id);
        $this->db->where('p.is_disable', 0);
        $query = $this->db->get();
        return $query->row_array();
    }

    // Update package
    public function update_package($id, $data)
    {
        $array = [
            'destination_id' => $data['destination_id'],
            'package_name'   => $data['package_name'],
            'package_code'   => $data['package_code'],
            'nights'         => $data['nights'],
            'days'           => $data['days'],
            'price'          => $data['price'],
            'updated'        => date('Y-m-d H:i:s'),
        ];

        $this->db->where('id', $id);
        return $this->db->update('packages', $array);
    }

    // Soft delete package
    public function delete_package($id)
    {
        $this->db->where('id', $id);
        return $this->db->update('packages', [
            'is_disable' => 1,
            'updated'    => date('Y-m-d H:i:s')
        ]);
    }

    // Insert package-themes mapping
    public function insert_package_themes($package_id, $themes)
    {
        $data = [];
        foreach ($themes as $theme_id) {
            $data[] = [
                'package_id' => $package_id,
                'theme_id'   => $theme_id,
                'created'    => date('Y-m-d H:i:s'),
                'updated'    => date('Y-m-d H:i:s')
            ];
        }
        if (!empty($data)) {
            $this->db->insert_batch('package_themes_mapping', $data);
        }
    }

    // Update package-themes mapping
    public function update_package_themes($package_id, $themes)
    {
        // Delete existing mappings
        $this->db->where('package_id', $package_id);
        $this->db->delete('package_themes_mapping');

        // Insert new mappings
        $this->insert_package_themes($package_id, $themes);
    }

    // Insert package-inclusions mapping
    public function insert_package_inclusions($package_id, $inclusions)
    {
        $data = [];
        foreach ($inclusions as $inc_id) {
            $data[] = [
                'package_id' => $package_id,
                'inclusion_id' => $inc_id,
                'created'    => date('Y-m-d H:i:s'),
                'updated'    => date('Y-m-d H:i:s')
            ];
        }
        if (!empty($data)) {
            $this->db->insert_batch('package_inclusions_mapping', $data);
        }
    }

    // Update package-inclusions mapping
    public function update_package_inclusions($package_id, $inclusions)
    {
        // Delete existing mappings
        $this->db->where('package_id', $package_id);
        $this->db->delete('package_inclusions_mapping');

        // Insert new mappings
        $this->insert_package_inclusions($package_id, $inclusions);
    }

    public function getPackagePricingResultData()
    {
        $this->db
            ->select('
                pp.id,
                pp.package_id,
                pp.price,
                pp.is_disable,
                pp.created_at,
                p.title as package_name,
                pd.id as price_date_id,
                pd.name as price_date_name,
                pd.from_date,
                pd.to_date
            ')
            ->from('package_pricing pp')
            ->join('packages p', 'p.id = pp.package_id', 'left')
            ->join('price_dates pd', 'pd.id = pp.price_date_id', 'left')
            ->order_by('p.title, pd.from_date', 'ASC');

        $query = $this->db->get();
        $result = $query->result_array();

        // Group results by package_id
        $grouped = [];
        foreach ($result as $row) {
            $package_id = $row['package_id'];

            if (!isset($grouped[$package_id])) {
                $grouped[$package_id] = [
                    'package_id'     => $package_id,
                    'package_name'   => $row['package_name'],
                    'is_disable'     => $row['is_disable'],
                    'created_at'     => $row['created_at'],
                    'prices'         => [] // multiple date-price entries
                ];
            }

            $grouped[$package_id]['prices'][] = [
                'price_date_name' => $row['price_date_name'],
                'from_date'       => $row['from_date'],
                'to_date'         => $row['to_date'],
                'price'           => $row['price']
            ];
        }

        return array_values($grouped); // reset keys for foreach in view
    }


    public function packageImage($package_id)
	{
		$images = $this->db->get_where('package_image',['package_id'=>$package_id])->result_array();
        $data = '';
        $i=1;
        foreach($images as $image){
            $data.= '<tr>';
            $data.= '<td>'.$i++.'</td>';
            $data.= '<td><img src="'.base_url('assets/uploads/'.$image['image']).'" height="70"></td>';
            $data.= '<td>';
            if($image['is_cover'] !=='1')
            {
                $data.= '<button class="btn btn-sm btn-danger" onclick="deletePackageImage('.$image['id'].','.$package_id.')">Delete</button>';
            }
            else{
                $data.= '<button class="btn btn-sm btn-danger" onclick="packageDeleteAlert()">Delete</button>';
            }
            if($image['is_cover']!=='1')
            {
                $data.='<button class="btn btn-sm btn-primary" onclick="makePackageCoverImage('.$image['id'].','.$package_id.')">Make cover</button>';
            }
            $data.='</td>';
            $data.= '</tr>';
        }
        echo $data;
	}

        public function addPackageImage($package_id)
	{
        $data = array();
        if (!empty($_FILES['package_image']['name'])) {
            $config['file_name'] = rand(10000, 10000000000);
            $config['upload_path'] = './assets/uploads/packages';
            $config['allowed_types'] = 'jpg|jpeg|png|';
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
    
            //upload images
            $_FILES['package_images']['name'] = $_FILES['package_image']['name'];
            $_FILES['package_images']['type'] = $_FILES['package_image']['type'];
            $_FILES['package_images']['tmp_name'] = $_FILES['package_image']['tmp_name'];
            $_FILES['package_images']['size'] = $_FILES['package_image']['size'];
            $_FILES['package_images']['error'] = $_FILES['package_image']['error'];

            if ($this->upload->do_upload('package_images')) {
                $image_data = $this->upload->data();

                $config2 = array(
                    'image_library' => 'gd2', //get original image
                    'source_image' =>  './assets/uploads/packages/'. $image_data['file_name'],
                    'width' => 540,
                    'height' => 600,
                    'maintain_ratio' => FALSE,
                    'new_image' =>  './assets/uploads/packages/'. $image_data['file_name'],

                );
                $this->load->library('image_lib');
                $this->image_lib->initialize($config2);
                $this->image_lib->resize();
                $this->image_lib->clear();

                $fileName = "packages/" . $image_data['file_name'];
                $data['image'] = $fileName;
                $data['package_id'] = $package_id;
            }
        } else {
            $data['image'] = '';
            $data['package_id'] = '';
        }
		return $this->db->insert('package_image', $data);
       
	}
    public function deletePackageImage($id)
    {
        $image = $this->model->getRowData('package_image',['id'=>$id]);
        $prod_image = ltrim($image['image'], '/');
        if(is_file(base_url('assets/uploads/'.$prod_image)))
        {
            unlink(base_url('assets/uploads/'.$prod_image));
        }
        return $this->db->delete('package_image',['id'=>$id]);
        
	}
}
