<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Price_dates extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn()
    {
        // if ($this->session->userdata('role') !== 'admin' && $this->session->userdata('role') !== 'staff') {
        //     redirect(base_url('dashboard'));
        //     exit;
        // }
    }

    public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header', $data);
        $this->load->view('includes/sidebar', $data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }

    /*--------------------------------------------
     | INDEX PAGE
     --------------------------------------------*/
    public function index()
    {
        $data['title'] = 'Price Dates Master';
        $page = 'price_dates/index';
        $this->header_and_footer($page, $data);
    }

    /*--------------------------------------------
     | ADD PRICE DATE
     --------------------------------------------*/
    public function addPriceDate()
    {
        // Check duplicate based on same name or overlapping date range if needed later
        $countData = $this->model->countData('price_dates', [
            'name' => $_POST['name']
        ]);

        if ($countData > 0) {
            echo json_encode(['return' => false, 'msg' => 'A price date with this name already exists']);
            return;
        }

        $array = [
            'name'      => $_POST['name'],
            'from_date' => $_POST['from_date'],
            'to_date'   => $_POST['to_date'],
            'remarks'   => $_POST['remarks'] ?? null,
        ];

        if ($this->model->add('price_dates', $array)) {
            $price_date_id = $this->db->insert_id();

            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $price_date_id,
                'add',
                'Price Date'
            );

            echo json_encode(['return' => true, 'msg' => 'Price Date Added Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Failed to add Price Date']);
        }
    }

    /*--------------------------------------------
     | VIEW LIST
     --------------------------------------------*/
    public function viewPriceDates()
    {
        $data['list'] = $this->model->getResultData('price_dates', []);
        $this->load->view('price_dates/tb', $data);
    }

    /*--------------------------------------------
     | EDIT
     --------------------------------------------*/
    public function editPriceDate()
    {
        $data = $this->model->getRowData('price_dates', ['id' => $_POST['id']]);

        $response = [
            'id'        => $data['id'],
            'name'      => $data['name'],
            'from_date' => $data['from_date'],
            'to_date'   => $data['to_date'],
            'remarks'   => $data['remarks'],
        ];

        echo json_encode($response);
    }

    /*--------------------------------------------
     | UPDATE
     --------------------------------------------*/
    public function updatePriceDate()
    {
        if (empty($_POST['id'])) {
            echo json_encode(['return' => false, 'msg' => 'Invalid Request']);
            return;
        }

        $id = $_POST['id'];

        $array = [
            'name'      => $_POST['name'],
            'from_date' => $_POST['from_date'],
            'to_date'   => $_POST['to_date'],
            'remarks'   => $_POST['remarks'] ?? null,
        ];

        if ($this->model->edit('price_dates', $array, ['id' => $id])) {
            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $id,
                'edit',
                'Price Date'
            );

            echo json_encode(['return' => true, 'msg' => 'Price Date Updated Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Update Failed']);
        }
    }

}
