<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller
{

    // public function __construct()
    // {
    //     parent::__construct();

    //     $this->isLoggedIn();
    // }

    // public function isLoggedIn(){
    //     $is_logged_in = $this->session->userdata('logged_in');
    //     if(!isset($is_logged_in) || $is_logged_in!==TRUE)
    //     {
    //         redirect(base_url());
    //         exit;
    //     }
    // }
    public function header_and_footer($page, $data)
    {

        $this->load->view('includes/header', $data);
        $this->load->view('includes/sidebar', $data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
    public function index()
    {
        $data['title'] = 'Dashboard';

        $data['package_inquiry_count'] = count($this->inquiry_model->getPackageInquiryResultData());
        $data['hotel_inquiry_count'] = count($data['list'] = $this->inquiry_model->getInquiryResultData());

        $hotel_pending_count = $this->model->countData('inquiries', ['status' => 'pending']);
        $package_pending_count = $this->model->countData('package_inquiries', ['status' => 'pending']);

        $data['pending_confirmation'] = $hotel_pending_count + $package_pending_count;


        // ✅ Total Business Value (sum of payment_received)
        $hotel_total = $this->model->getSum('inquiries', 'total_amount', ['status' => 'payment_received']);
        $package_total = $this->model->getSum('package_inquiries', 'price', ['status' => 'payment_received']);
        $data['total_business_value'] = $hotel_total + $package_total;


        $page = 'dashboard';
        $this->header_and_footer($page, $data);
    }
    public function logout()
    {
        if ($this->session->userdata('role') == 'admin') {
            $redirect = 'admin';
        } else if ($this->session->userdata('role') == 'staff') {
            $redirect = 'staff-login';
        } else if ($this->session->userdata('role') == 'turf_owner') {
            $redirect = 'turf-owner-login';
        }
        $this->session->unset_userdata(array('logged_in', 'email', 'role', 'id', 'mobile'));
        redirect(base_url($redirect));
    }
    function multipleDel()
    {
        $this->multipleDelete();
    }
    function Status()
    {
        $this->changeStatus();
    }
    public function fetch_state()
    {
        if ($this->input->post('country_id')) {
            $cid = $this->input->post('country_id');
            $this->model->fetch_state($cid, $this->input->post('state_id'));
        }
    }
    public function fetch_cities_by_destination_id()
    {
        if ($this->input->post('destination_id')) {
            $destination_id = $this->input->post('destination_id');
            $this->model->fetch_cities_by_destination_id($destination_id);
        }
    }
    public function fetch_city()
    {
        if ($this->input->post('state_id')) {
            $sid = $this->input->post('state_id');
            $this->model->fetch_city($sid, $this->input->post('city_id'));
        }
    }
    public function fetch_chapter()
    {
        if ($this->input->post('subject_id')) {
            $subject_id = $this->input->post('subject_id');
            $this->model->fetch_chapter($subject_id, $this->input->post('chapter_id'));
        }
    }
    public function fetch_subjects()
    {
        if ($this->input->post('class_standard_id')) {
            $cid = $this->input->post('class_standard_id');
            $this->model->fetch_subjects($cid, $this->input->post('subject_id'));
        }
    }
    public function fetch_class()
    {
        if ($this->input->post('board_id')) {
            $board_id = $this->input->post('board_id');
            $this->model->fetch_class($board_id, $this->input->post('class_standard_id'));
        }
    }

    protected $table;

    public function delete()
    {
        // Get values from AJAX
        $id = $this->input->post('id');
        $table = $this->input->post('table');

        // Basic validation
        if (empty($id) || empty($table)) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Invalid request: missing ID or table name.'
            ]);
            return;
        }


        // Perform delete
        $deleted = $this->db->where('id', $id)->delete($table);

        // Return response
        if ($deleted) {
            echo json_encode([
                'status' => 'success',
                'message' => ' record deleted successfully.'
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Delete operation failed.'
            ]);
        }
    }


}
