<div class="page-body">
          <div class="container-fluid">
            <div class="page-title">
              <div class="row">
                <div class="col-6">
                  <h3><?= $title; ?></h3>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid starts-->
          <div class="container-fluid">
            <div class="row">
              <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                  <div class="row">
                    <div class="col-sm-6">
                      <h5><?= $title; ?></h5>
                    </div>
                    <div class="col-sm-6 text-right">
                      <button class="btn btn-success rounded add-btn" type="button" data-bs-toggle="modal" data-bs-target="#addModal" data-bs-original-title="Add <?= $title; ?>"><i class="fa fa-plus"></i> Add <?= $title; ?></button>
                    </div>
                  </div>
                  <?php if($this->session->userdata('usertype') !== 'staff'){ ?>
                  <div class="row">
                    <div class="col-sm-6 mt-5">
                      <div class="mb-3 row">
                        <label class="col-sm-3 col-form-label">Staff</label>
                        <div class="col-sm-9">
                        <select id="staff_id" class="form-control" onchange="viewTransaction()">
                          <option value="">Select</option>
                          <?php foreach($staffs as $staff){ ?>
                            <option value="<?= $staff['id'];?>"><?= $staff['fullname']; ?></option>
                          <?php } ?>
                        </select>
                        </div>
                      </div>
                    </div>
                  </div>
                  <?php } ?>
                  </div>
                  <div class="card-body">
                    <div class="table-responsive" id="tb">
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid Ends-->
        </div>
        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="add-form">
                  <div class="row g-2">
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Staff <span class="text-danger">*</span></label>
                      <select class="form-control" id="staff_id" name="staff_id" required>
                          <option value="">Select</option>
                          <?php foreach($staffs as $staff){ ?>
                            <option value="<?= $staff['id'] ?>"><?= $staff['fullname']; ?></option>
                          <?php } ?>
                        </select>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Month/Year<span class="text-danger">*</span></label>
                      <input class="form-control" name="month_year" id="month_year" type="month" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Amount<span class="text-danger">*</span></label>
                      <input class="form-control" name="amount" id="amount" type="number" step="any" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Note</label>
                      <textarea class="form-control" name="note" id="note"></textarea>
                    </div>
                  </div>
                  <button class="btn btn-secondary" type="submit">Save</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>

        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="edit-form">
                  <div class="row g-2">
                  <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Staff <span class="text-danger">*</span></label>
                      <select class="form-control" id="e_staff_id" name="staff_id" required>
                          <option value="">Select</option>
                          <?php foreach($staffs as $staff){ ?>
                            <option value="<?= $staff['id'] ?>"><?= $staff['fullname']; ?></option>
                          <?php } ?>
                        </select>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Month/Year<span class="text-danger">*</span></label>
                      <input class="form-control" name="month_year" id="e_month_year" type="month" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Amount<span class="text-danger">*</span></label>
                      <input class="form-control" name="amount" id="e_amount" type="number" step="any" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Note</label>
                      <textarea class="form-control" name="note" id="e_note"></textarea>
                    </div>
                  </div>
                  <input type="hidden" name="id" id="id">
                  <button class="btn btn-secondary" type="submit">Update</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>
<script>
$(document).ready(function(){
  $('#addModal').modal({
           backdrop: 'static',
           keyboard: false
    })
    $('#editModal').modal({
           backdrop: 'static',
           keyboard: false
    })
viewTransaction();
});
function viewTransaction()
{
    $.ajax({
      url: "<?= base_url('transaction/viewTransaction'); ?>",
      method: "POST",
      data: {
        'staff_id':$('#staff_id').val()
      },
      success:function(res){
          $('#tb').html(res);
      }
  });
}
$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  var formData = new FormData(this);
  $.ajax({
      url: "<?php echo base_url('transaction/addTransaction'); ?>",
      method: "POST",
      data:  formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#addModal').modal('toggle'); 
          $('#add-form')[0].reset();
          $('#tb').load('<?= base_url('transaction/viewTransaction'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
});
function editTransaction(id)
{
  $.ajax({
      url: "<?php echo base_url('transaction/editTransaction'); ?>",
      method: "POST",
      data: {
          id:id
      },
      dataType: 'json',
      success:function(res){
        $("#id").val(res.id);
        $("#e_staff_id").val(res.staff_id);
        $("#e_month_year").val(res.month_year);
        $("#e_amount").val(res.amount);
        $("#e_note").val(res.note);

      }
  });
};
$("#edit-form").submit(function(e){
  e.preventDefault();
  disableButton();
  var formData = new FormData(this);
  $.ajax({
      url: "<?php echo base_url('transaction/updateTransaction'); ?>",
      method: "POST",
      data:  formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#editModal').modal('toggle'); 
          viewTransaction();
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
});

</script>