        <div class="page-body">
          <div class="container-fluid">
            <div class="page-title">
              <div class="row">
                <div class="col-6">
                  <h3><?= $title; ?></h3>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid starts-->
          <div class="container-fluid">
            <div class="row">
              <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                  <div class="row">
                  <div class="col-sm-6">
                    <h5><?= $title; ?></h5>
                  </div>
                  <div class="col-sm-6 text-right">
                    <button class="btn btn-success rounded add-btn" type="button" onclick="add()"><i class="fa fa-plus"></i> Add <?= $title; ?></button>
                   </div>
                 </div>
                  </div>
                  <div class="card-body">
                    <div class="table-responsive" id="tb">
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid Ends-->
        </div>
        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="add-form">
                  <div class="row g-2">
                    <div class="mt-0 col-md-12">
                      <p id="error"></p>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                        <label for="bm-title">Dealer</label>
                        <select name="dealer_id" id="dealer_id" class="form-control" required> 
                        <option value="">Select</option>
                        <?php foreach($dealers as $dealer){ ?>
                            <option value="<?= $dealer['id'] ?>"><?= $dealer['fullname']; ?></option>
                          <?php } ?>                    
                        </select>
                    </div>  
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Fullname <span class="text-danger">*</span></label>
                      <input class="form-control" id="fullname" type="text" name="fullname" required>
                    </div>
                     <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Country Code <span class="text-danger">*</span></label>
                        <select class="form-control select2" name="ccode"  id="ccode" required>
                            <option value="">Select</option>
                            <?php foreach (getCountryWithPhoneCode() as $ccodekey => $ccodevalue): ?>
                                <option data-atr="<?= $ccodevalue['code'].' +'.$ccodevalue['phone']?>" data-ctr="<?= $ccodevalue['name'].' (+'.$ccodevalue['phone'].')' ?>" value="<?= $ccodevalue['phone'] ?>"><?= $ccodevalue['name'].' (+'.$ccodevalue['phone'].')' ?></option>
                            <?php endforeach ?>   
                        </select>
                      </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Mobile <span class="text-danger">*</span></label>
                      <input name="mobile"  id="mobile" class="form-control" type="text" pattern="[1-9]{1}[0-9]{9}" title="Enter 10 digit contact number" placeholder="Mobile number" maxlength="10"  required>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Email <span class="text-danger">*</span></label>
                      <input class="form-control" id="emailid" name="emailid" type="email" name="email" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Executive ID <span class="text-danger">*</span></label>
                      <input class="form-control" id="exe_id" type="text" name="exe_id" 
                      value="<?= $exeId ?>" readonly
                      required>
                    </div>
                    
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Gender</label>
                      <select class="form-control" id="gender" name="gender">
                          <option value="">Select</option>
                          <option value="Male">Male</option>
                          <option value="Female">Female</option>
                          <option value="Other">Other</option>
                      </select>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Date of Birth</label>
                      <input class="form-control" id="dob" type="date" name="dob" max="<?= date('Y-m-d',strtotime("-1 days")); ?>">
                    </div>
                   
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Address</label>
                      <textarea class="form-control" id="address" name="address"></textarea>
                    </div>
                    
                  </div>
                  <button class="btn btn-secondary" type="submit">Add</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>

        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Edit <?= $title; ?></h5>
      <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
    </div>
    <div class="modal-body">
    <form class="form-bookmark" id="edit-form">
        <div class="row g-2">
            <div class="mb-3 mt-0 col-md-6">
                <label for="bm-title">Dealer</label>
                <select name="dealer_id" id="e_dealer_id" class="form-control" required> 
                <option value="">Select</option>
                <?php foreach($dealers as $dealer){ ?>
                    <option value="<?= $dealer['id'] ?>"><?= $dealer['fullname']; ?></option>
                  <?php } ?>                    
                </select>
            </div> 
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Fullname <span class="text-danger">*</span></label>
              <input class="form-control" name="fullname" id="efullname" type="text" required="">
            </div>
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Country Code <span class="text-danger">*</span></label>
              <select class="form-control select2" name="ccode"  id="e_ccode" required>
                  <option value="">Select</option>
                  <?php foreach (getCountryWithPhoneCode() as $ccodekey => $ccodevalue): ?>
                      <option data-atr="<?= $ccodevalue['code'].' +'.$ccodevalue['phone']?>" data-ctr="<?= $ccodevalue['name'].' (+'.$ccodevalue['phone'].')' ?>" value="<?= $ccodevalue['phone'] ?>"><?= $ccodevalue['name'].' (+'.$ccodevalue['phone'].')' ?></option>
                  <?php endforeach ?>   
              </select>
            </div>
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Mobile <span class="text-danger">*</span></label>
              <input name="mobile"  id="e_mobile" class="form-control" type="text" pattern="[1-9]{1}[0-9]{9}" title="Enter 10 digit mobile number" placeholder="Mobile number" required >
            </div>
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Email <span class="text-danger">*</span></label>
              <input class="form-control" id="eemailid" name="emailid" type="email" required="">
            </div>
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Gender </label>
              <select class="form-control" id="e_gender" name="gender">
                  <option value="">Select</option>
                  <option value="Male">Male</option>
                  <option value="Female">Female</option>
                  <option value="Other">Other</option>
              </select>
            </div>
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Date of Birth</label>
              <input class="form-control" id="e_dob" type="date" name="dob" max="<?= date('Y-m-d',strtotime("-1 days")); ?>">
            </div>
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Executive ID <span class="text-danger">*</span></label>
              <input class="form-control" id="e_exe_id" type="text" name="exe_id" readonly required>
            </div>
         
            <div class="mb-3 mt-0 col-md-12">
              <label for="bm-title">Address</label>
              <textarea class="form-control" id="e_address" name="address"></textarea>
            </div>
        </div>
        <input type="hidden" id="e_id" name="id">
        <button class="btn btn-secondary" type="submit">Update</button>
        <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
    </form>
    </div>
  </div>
</div>
        </div>

<script>
  function add()
  {
    $('#addModal').modal('toggle'); 
    $('#add-form')[0].reset();
  }
$(document).ready(function(){
  $('#addModal').modal({
           backdrop: 'static',
           keyboard: false
    })
    $('#editModal').modal({
           backdrop: 'static',
           keyboard: false
    })
  $('#tb').load('<?= base_url('marketing_executive/viewMarketingExecutive'); ?>');
});


$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('marketing_executive/addMarketingExecutive'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#addModal').modal('toggle'); 
          $('#add-form')[0].reset();
          $('#tb').load('<?= base_url('marketing_executive/viewMarketingExecutive'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
})
function editMarketingExecutive(id)
{
  $.ajax({
      url: "<?= base_url('marketing_executive/editMarketingExecutive'); ?>",
      method: "POST",
        dataType: 'json',
      data: {
          id:id
      },
      success:function(res){
          $("#e_id").val(res.id);
          $("#e_dealer_id").val(res.dealer_id);
          $("#efullname").val(res.fullname);
          $("#eemailid").val(res.email);
          $("#e_mobile").val(res.mobile);
          $("#e_ccode option[value='"+res.ccode+"']").attr("selected", "selected");
          $("#e_exe_id").val(res.exe_id);
          $("#e_gender option[value='"+res.gender+"']").attr("selected", "selected");
          $("#e_dob").val(res.dob);
          $("#e_address").val(res.address);
      }
  });
};
$("#edit-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('marketing_executive/updateMarketingExecutive'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
  
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#editModal').modal('toggle'); 
          $('#tb').load('<?= base_url('marketing_executive/viewMarketingExecutive'); ?>');
          toastr.success(res.msg);
        }
        else
        {          
          toastr.error(res.msg);
        }
      }
  });
})

</script>