        <div class="page-body">
          <div class="container-fluid">
            <div class="page-title">
              <div class="row">
                <div class="col-6">
                  <h3>Customers</h3>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid starts-->
          <div class="container-fluid">
            <div class="row">
              <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                  <div class="row">
                  <div class="col-sm-6">
                    <h5>Customers</h5>
                  </div>
                  <div class="col-sm-6 text-right">
                    <button class="btn btn-success rounded add-btn" type="button" onclick="addCustomer()"><i class="fa fa-plus"></i> Add Customer</button>
                   </div>
                 </div>
                  </div>
                  <div class="card-body">
                    <div class="table-responsive" id="tb">
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid Ends-->
        </div>
        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="addCustomerModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add Customer</h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="add-customer-form">
                  <div class="row g-2">
                    <div class="mt-0 col-md-12">
                      <p id="error"></p>
                    </div>
                    
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Company <span class="text-danger">*</span></label>
                      <select name="company" id="company" class="form-control" required> 
                        <option value="">Select</option>
                        <?php foreach($companies as $company){ ?>
                            <option value="<?= $company['id'] ?>"><?= $company['company']; ?></option>
                          <?php } ?>                    
                        </select>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Person Fullname <span class="text-danger">*</span></label>
                      <input class="form-control" id="fullname" type="text" name="fullname" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-4">
                      <label for="bm-title">Person Email <span class="text-danger">*</span></label>
                      <input class="form-control" id="person_emailid" type="email" name="person_emailid" required>
                    </div>
                     <div class="mb-3 mt-0 col-md-4">
                      <label for="bm-title">Country Code <span class="text-danger">*</span></label>
                        <select class="form-control select2" name="ccode"  id="ccode" required>
                            <option value="">Select</option>
                            <?php foreach (getCountryWithPhoneCode() as $ccodekey => $ccodevalue): ?>
                                <option data-atr="<?= $ccodevalue['code'].' +'.$ccodevalue['phone']?>" data-ctr="<?= $ccodevalue['name'].' (+'.$ccodevalue['phone'].')' ?>" value="<?= $ccodevalue['phone'] ?>"><?= $ccodevalue['name'].' (+'.$ccodevalue['phone'].')' ?></option>
                            <?php endforeach ?>   
                        </select>
                      </div>
                    <div class="mb-3 mt-0 col-md-4">
                      <label for="bm-title">Person Mobile <span class="text-danger">*</span></label>
                      <input name="mobile"  id="mobile" class="form-control" type="text" pattern="[1-9]{1}[0-9]{9}" title="Enter 10 digit contact number" placeholder="Mobile number" maxlength="10"  required>
                    </div>    
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Pan no. <span class="text-danger">*</span></label>
                      <input name="pan_no"  id="pan_no" class="form-control" type="text"  required>
                    </div>  
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Visiting card</label>
                      <input name="visiting_card"  id="visiting_card" class="form-control" type="file" >
                    </div>  
                    <div class="mb-3 mt-0 col-md-4">
                      <label for="bm-title">Country</label>
                      <select name="country" class="form-control" id="country" onchange="fetch_state(this.value)">
                          <option value="">Select Country</option>
                          <?php foreach($countries as $country){ ?>
                            <option value="<?= $country['id']; ?>"><?= $country['name']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                    <div class="mb-3 mt-0 col-md-4">
                      <label for="bm-title">State</label>
                      <select name="state" class="state form-control" id="state" onchange="fetch_city(this.value)">
                      </select>                    
                    </div>
                    <div class="mb-3 mt-0 col-md-4">
                      <label for="bm-title">City</label>
                      <select name="city" class="city form-control" id="city">
                      </select>                 
                    </div> 
                    
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Address</label>
                      <textarea class="form-control" id="address" type="text" required="" name="address"></textarea>
                    </div>     
                  </div>
                  <div class="text-center">
                  <button class="btn btn-secondary" type="submit">Add</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>

        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="editCustomerModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Edit Customer</h5>
      <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
    </div>
    <div class="modal-body">
    <form class="form-bookmark" id="edit-customer-form">
        <div class="row g-2">
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Company Name <span class="text-danger">*</span></label>
              <select name="company" id="ecompany" class="form-control" required> 
                <option value="">Select</option>
                <?php foreach($companies as $company){ ?>
                    <option value="<?= $company['id'] ?>"><?= $company['company']; ?></option>
                  <?php } ?>                    
              </select>
            </div>
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Person Fullname <span class="text-danger">*</span></label>
              <input class="form-control" id="efullname" name="fullname" type="text" required="">
            </div>
            <div class="mb-3 mt-0 col-md-4">
              <label for="bm-title">Person Email <span class="text-danger">*</span></label>
              <input class="form-control" id="person_eemailid" name="person_emailid" type="email" required="">
            </div>
            <div class="mb-3 mt-0 col-md-4">
              <label for="bm-title">Country Code <span class="text-danger">*</span></label>
              <select class="form-control select2" name="ccode"  id="e_ccode" required>
                  <option value="">Select</option>
                  <?php foreach (getCountryWithPhoneCode() as $ccodekey => $ccodevalue): ?>
                      <option data-atr="<?= $ccodevalue['code'].' +'.$ccodevalue['phone']?>" data-ctr="<?= $ccodevalue['name'].' (+'.$ccodevalue['phone'].')' ?>" value="<?= $ccodevalue['phone'] ?>"><?= $ccodevalue['name'].' (+'.$ccodevalue['phone'].')' ?></option>
                  <?php endforeach ?>   
              </select>
            </div>
            <div class="mb-3 mt-0 col-md-4">
              <label for="bm-title">Person Mobile <span class="text-danger">*</span></label>
              <input name="mobile"  id="e_mobile" name="mobile" class="form-control" type="text" pattern="[1-9]{1}[0-9]{9}" title="Enter 10 digit mobile number" placeholder="Mobile number" required >
            </div>
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Pan no. <span class="text-danger">*</span></label>
              <input name="pan_no"  id="e_pan_no" name="pan_no" class="form-control" type="text"  required>
            </div>  
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Visiting card</label>
              <input name="visiting_card"  id="e_visiting_card" name="visiting_card" class="form-control" type="file" >
              <img id="imageview" height="70" style="margin-top:20px">
            </div>  
            <div class="mb-3 mt-0 col-md-4">
              <label for="bm-title">Country</label>
              <select name="country" class="form-control" id="e_country" onchange="fetch_state(this.value)">
                  <option value="">Select Country</option>
                  <?php foreach($countries as $country){ ?>
                    <option value="<?= $country['id']; ?>"><?= $country['name']; ?></option>
                  <?php } ?>
              </select>                   
            </div>
            <div class="mb-3 mt-0 col-md-4">
              <label for="bm-title">State</label>
              <select name="state" class="state form-control" id="e_state" onchange="fetch_city(this.value)">
              </select>                    
            </div>
            <div class="mb-3 mt-0 col-md-4">
              <label for="bm-title">City</label>
              <select name="city" class="city form-control" id="e_city">
              </select>                 
            </div> 
            <div class="mb-3 mt-0 col-md-12">
              <label for="bm-title">Address</label>
              <textarea class="form-control" id="e_address" name="address" type="text" required="" name="address"></textarea>
            </div>
        </div>
        <input type="hidden" id="e_id" name="id">
        <button class="btn btn-secondary" type="submit">Update</button>
        <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
    </form>
    </div>
  </div>
</div>
        </div>

      <!-- <div class="modal fade modal-bookmark" id="changePasswordModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="exampleModalLabel">Change Password</h5>
              <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <form class="form-bookmark" id="change-password-form">
                <div class="row g-2">
                  <div class="mb-3 mt-0 col-md-6">
                    <label for="bm-title">New Password</label>
                    <input class="form-control" id="new_password" type="password" required="">
                  </div>
                  <div class="mb-3 mt-0 col-md-6">
                    <label for="bm-title">Confirm Password</label>
                    <input class="form-control" id="confirm_password" type="password" required="">
                  </div>
                  <input type="hidden" id="staff_id">
                </div>
                <button class="btn btn-secondary submit-btn" type="submit">Save</button>
                <button class="btn btn-primary cancel-btn" type="button">Cancel</button>
              </form>
            </div>
          </div>
        </div>
      </div> -->
<script>
  function addCustomer()
  {
    $('#addCustomerModal').modal('toggle'); 
    $('#add-customer-form')[0].reset();
    $('#city').find('option:not(:first)').remove();
    $('#state').find('option:not(:first)').remove();
  }
$(document).ready(function(){
  $("#tb").html('<div class="text-center"><img src="loader.gif"></div>');
  $('#addCustomerModal').modal({
           backdrop: 'static',
           keyboard: false
    })
    $('#editCustomerModal').modal({
           backdrop: 'static',
           keyboard: false
    })
  $('#tb').load('<?= base_url('customer/viewCustomer'); ?>');
});


$("#add-customer-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('customer/addCustomer'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#addCustomerModal').modal('toggle'); 
          $('#add-customer-form')[0].reset();
          $('#tb').load('<?= base_url('customer/viewCustomer'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
})
function editCustomer(id)
{
  $.ajax({
      url: "<?= base_url('customer/editCustomer'); ?>",
      method: "POST",
        dataType: 'json',
      data: {
          id:id
      },
      success:function(res){
          fetch_state(res.country,res.state);
          fetch_city(res.state,res.city);
          $("#e_id").val(res.id);
          $("#efullname").val(res.fullname);
          $("#ecompany").val(res.company);
          $("#person_eemailid").val(res.person_emailid);
          $("#e_mobile").val(res.mobile);
          $("#e_ccode option[value='"+res.ccode+"']").attr("selected", "selected");
          $("#imageview").attr("src", ""+res.visiting_card+"");
          $("#imageview").val(res.visiting_card);
          $("#e_pan_no").val(res.pan_no);
          $("#e_address").val(res.address);
          $("#e_country_id").val(res.country_id);
      }
  });
};
$("#edit-customer-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('customer/updateCustomer'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#editCustomerModal').modal('toggle'); 
          $('#tb').load('<?= base_url('customer/viewCustomer'); ?>');
          toastr.success(res.msg);
        }
        else
        {          
          toastr.error(res.msg);
        }
      }
  });
})

function fetch_state(country_id,state_id) {
    $.ajax({
      url: "<?= base_url('dashboard/fetch_state'); ?>",
      method: "POST",
      data: {
        country_id: country_id,
        state_id: state_id
      },
      success: function(data) {
        if(state_id == null)
        {
          $(".state").html(data);
        }
        else
        {
          $("#e_state").html(data);
        }
      },
    });
}
  function fetch_city(state_id,city_id) {
    $.ajax({
      url: "<?= base_url('dashboard/fetch_city'); ?>",
      method: "POST",
      data: {
        state_id: state_id,
        city_id: city_id
      },
      success: function(data) {
        if(city_id == null)
        {
          $(".city").html(data);
        }
        else
        {
          $("#e_city").html(data);
        }
      },
    });
  }
</script>