<?php


class Customer_model extends CI_Model
{
    public function addCustomer($data)
	{
		$config['file_name'] = rand(10000, 10000000000);
        $config['upload_path'] = './assets/uploads/customer';
        $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';
        $this->load->library('upload', $config);
        $this->upload->initialize($config);

		//Document1
        if (!empty($_FILES['visiting_card']['name'])) {
            //upload images
            $_FILES['visiting_cards']['name'] = $_FILES['visiting_card']['name'];
            $_FILES['visiting_cards']['type'] = $_FILES['visiting_card']['type'];
            $_FILES['visiting_cards']['tmp_name'] = $_FILES['visiting_card']['tmp_name'];
            $_FILES['visiting_cards']['size'] = $_FILES['visiting_card']['size'];
            $_FILES['visiting_cards']['error'] = $_FILES['visiting_card']['error'];

            if ($this->upload->do_upload('visiting_cards')) {
                $image_data = $this->upload->data();

                $fileName = "customer/" . $image_data['file_name'];
            }
            $data['visiting_card'] = $fileName;
        } else {
            $data['visiting_card'] = "";
        }

         return $this->db->insert('customer', $data);
	}
    public function updateCustomer($data,$id)
	{
		$config['file_name'] = rand(10000, 10000000000);
        $config['upload_path'] = './assets/uploads/customer';
        $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';
        $this->load->library('upload', $config);
        $this->upload->initialize($config);

		//Document1
        if (!empty($_FILES['visiting_card']['name'])) {
            //upload images
            $_FILES['visiting_cards']['name'] = $_FILES['visiting_card']['name'];
            $_FILES['visiting_cards']['type'] = $_FILES['visiting_card']['type'];
            $_FILES['visiting_cards']['tmp_name'] = $_FILES['visiting_card']['tmp_name'];
            $_FILES['visiting_cards']['size'] = $_FILES['visiting_card']['size'];
            $_FILES['visiting_cards']['error'] = $_FILES['visiting_card']['error'];

            if ($this->upload->do_upload('visiting_cards')) {
                $image_data = $this->upload->data();

                $fileName = "customer/" . $image_data['file_name'];
            }
            $data['visiting_card'] = $fileName;
        }
		if (!empty($fileName))    
		{
			$images = $this->model->getRowData('customer',['id'=>$id]);
			$image = ltrim($images['visiting_card'], '/');
			if(is_file('./assets/uploads/'.$image))
			{
				unlink('./assets/uploads/'.$image);
			}
		}
	
         return $this->db->where('id',$id)->update('customer', $data);
	}
    public function getCustomerRowData($id)
	{
        $query = $this->db
        ->select('t1.*,t2.name as country_name,t3.name as state_name,t4.name as city_name')
        ->from('customer t1')
        ->join('countries t2', 't2.id = t1.country','left') 
        ->join('states t3', 't3.id = t1.state','left') 
        ->join('cities t4', 't4.id = t1.city','left') 
        ->where(['t1.id'=>$id])
        ->get();
		return $query->row_array();
	}
    public function getCustomerResultData()
	{
        $query = $this->db
        ->select('t1.*,t2.name as country_name,t3.name as state_name,t4.name as city_name')
        ->from('customer t1')
        ->join('countries t2', 't2.id = t1.country','left') 
        ->join('states t3', 't3.id = t1.state','left') 
        ->join('cities t4', 't4.id = t1.city','left') 
        ->order_by('t1.id','DESC')
        ->get();
		return $query->result_array();
	}






    public function getPaymentRowData($id)
	{
        $query = $this->db
        ->select('t1.*,t2.fullname')
        ->from('payment t1')
        ->join('customer t2','t2.id = t1.customer_id','left')
        ->where(['t1.id'=>$id])
        ->get();
		return $query->row_array();
	}
    public function getCustomerDocRowData($id)
	{
        $query = $this->db
        ->select('t1.*,t2')
        ->from('customer_docs t1')
        ->join('customer t2','t2.id = t1.customer_id','left')
        ->where(['t1.id'=>$id])
        ->get();
		return $query->row_array();
	}
    public function getPaymentResultData()
	{
        $query = $this->db
        ->select('t1.*,t2.fullname')
        ->from('payment t1')
        ->join('customer t2','t2.id = t1.customer_id','left')
        ->order_by('t1.id','DESC')
        ->get();
		return $query->result_array();
	}
	public function getDocumentResultData($customerId)
    {
        $query = $this->db
            ->select('t1.*, t2.fullname')
            ->from('customer_docs t1')
            ->join('customer t2', 't2.id = t1.customer_id', 'left')
            ->where(['t1.customer_id' => $customerId])
            ->get();

        return $query->result_array();
    }



	
	public function deleteDocument($id)
    {
        $images = $this->model->getRowData('customer_docs',['id'=>$id]);
        $doc1_image = ltrim($images['document1'], '/');
        if(is_file('./assets/uploads/'.$doc1_image))
        {
            unlink('./assets/uploads/'.$doc1_image);
        }
		$doc2_image = ltrim($images['document2'], '/');
        if(is_file('./assets/uploads/'.$doc2_image))
        {
            unlink('./assets/uploads/'.$doc2_image);
        }
		$doc3_image = ltrim($images['document3'], '/');
        if(is_file('./assets/uploads/'.$doc3_image))
        {
            unlink('./assets/uploads/'.$doc3_image);
        }
		$doc4_image = ltrim($images['document4'], '/');
        if(is_file('./assets/uploads/'.$doc4_image))
        {
            unlink('./assets/uploads/'.$doc4_image);
        }
		return $this->db->where('id', $id)->delete('customer_docs');
	}
}

?>