<?php


class Api_model extends CI_Model
{
    public function getProductRowData($id)
	{
        $query = $this->db
        ->select('t1.*,t2.name as category_name,t3.fullname as dealer_name,t4.name as unit_name')
        ->from('product t1')
        ->join('product_category t2','t2.id = t1.category_id','left')
        ->join('distributor t3','t3.id = t1.dealer_id','left')
        ->join('unit t4','t4.id = t1.unit_id','left')
        ->where(['t1.id'=>$id])
        ->get();
		return $query->row_array();
	}
    public function getProductResultData($category_id=null,$dealer_id=null)
	{
        $this->db
        ->select('t1.*,t2.name as category_name,t3.fullname as dealer_name,t4.name as unit_name')
        ->from('product t1')
        ->join('product_category t2','t2.id = t1.category_id','left')
        ->join('distributor t3','t3.id = t1.dealer_id','left')
        ->join('unit t4','t4.id = t1.unit_id','left');
        if(isset($category_id) && $category_id!==null){
            $this->db->where('t1.category_id',$category_id);
        }
        if(isset($dealer_id) && $dealer_id!==null){
            $this->db->where('t1.dealer_id',$dealer_id);
        }
        
        $query = $this->db->get();
		return $query->result_array();
	}

    //order
    public function getOrderRowData($id)
	{
        $query = $this->db
        ->select('t1.*,t2.fullname as customer_name,t3.name as category_name,t4.name as product_name,t4.dealer_id,t5.fullname as dealer_name')
        ->from('orders t1')
        ->join('customer t2','t2.id = t1.customer_id','left')
        ->join('product_category t3','t3.id = t1.category_id','left')
        ->join('product t4','t4.id = t1.product_id','left')
        ->join('distributor t5','t5.id = t4.dealer_id','left')
        ->where(['t1.id'=>$id])
        ->get();
		return $query->row_array();
	}
    public function getOrderResultData($customer_id=null,$dealer_id=null)
	{
        $this->db
        ->select('t1.*,t2.fullname as customer_name,t3.name as category_name,t4.name as product_name,t4.dealer_id,t5.fullname as dealer_name')
        ->from('orders t1')
        ->join('customer t2','t2.id = t1.customer_id','left')
        ->join('product_category t3','t3.id = t1.category_id','left')
        ->join('product t4','t4.id = t1.product_id','left')
        ->join('distributor t5','t5.id = t4.dealer_id','left');
        if(isset($customer_id) && $customer_id!==null){
            $this->db->where(['t1.customer_id'=>$customer_id]);
        }
        if(isset($dealer_id) && $dealer_id!==null){
            $this->db->where(['t1.dealer_id'=>$dealer_id]);
        }
        
        $query = $this->db->get();
		return $query->result_array();
	}
    //Dealer
    public function getDealerRowData($id)
	{
        $query = $this->db
        ->select('t1.*,t2.name as country_name,t3.name as state_name,t4.name as city_name')
        ->from('distributor t1')
        ->join('countries t2', 't2.id = t1.country','left') 
        ->join('states t3', 't3.id = t1.state','left') 
        ->join('cities t4', 't4.id = t1.city','left') 
        ->where(['t1.id'=>$id])
        ->get();
		return $query->row_array();
	}
    //quotation
    public function getQuotationRowData($id)
	{
        $query = $this->db
        ->select('t1.*,t2.fullname as customer_name,t3.company as company_name')
        ->from('quotation t1')
        ->join('customer t2', 't2.id = t1.customer_id','left') 
        ->join('company t3', 't3.id = t1.company_id','left') 
        ->where(['t1.id'=>$id])
        ->order_by('t1.id','DESC')
        ->get();
		return $query->row_array();
	}
    public function getQuotationProductsData($quotation_id)
	{
        $query = $this->db
        ->select('t1.*,t2.quotation_id as quotationId,t3.name as product_name')
        ->from('quotation_products t1')
        ->join('quotation t2', 't2.id = t1.quotation_id','left') 
        ->join('product t3', 't3.id = t1.product_id','left') 
        ->where(['t1.quotation_id'=>$quotation_id])
        ->get();
		return $query->result_array();
	}
	
}

?>