<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Marketing_executive extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Marketing Executive';
		//generate executive id
		if($this->model->countData('marketing_executive',[]) > 0){
			$number = $this->model->getRowData('marketing_executive',[],null,'id','DESC')['id'] + 1;
			$number = sprintf('%03d',$number);
			$data['exeId'] = 'EXE'.$number;
		}else{
			$data['exeId'] = 'EXE'.sprintf('%03d',1);
		}
		$data['countries'] = $this->model->getResultData('countries',[]);
		$data['dealers'] = $this->model->getResultData('distributor',['is_suspended'=>0]);
        $page = 'marketing_executive/index';
        $this->header_and_footer($page, $data);
    }
	public function addMarketingExecutive()
    {
		$countEmail = $this->model->countData('marketing_executive',['emailid'=>$_POST['emailid']]);
		if($countEmail > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		}
		else
		{
			if($_POST['fullname'])
			{
				$array = array(
					'dealer_id' => $_POST['dealer_id'],
					'fullname' => ucfirst($_POST['fullname']),
					'emailid' => $_POST['emailid'],
					'mobile' =>  '+'.$_POST['ccode'].' '.$_POST['mobile'],
					'exe_id' => $_POST['exe_id'],
					'gender' => $_POST['gender'],
					'dob' => $_POST['dob'],
					'address' => $_POST['address'],
				);
				if($this->model->add('marketing_executive',$array))
				{
					$lead_id = $this->db->insert_id();
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','marketing executive detail');

					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
				
			}
		}
    }
	public function viewMarketingExecutive()
    {
		$data['list'] = $this->model->getResultData('marketing_executive',[]);
		$this->load->view('marketing_executive/tb',$data);
    }
	public function editMarketingExecutive()
    {
        $response=array();
		$data = $this->model->getRowData('marketing_executive',['id' => $_POST['id']]);
		if($data['mobile'] !== '')
		{
			$mob = explode(' ',$data['mobile']);
			$ccode = $mob[0];
			$contact = $mob[1];
		}else{
			$mob = '';
			$ccode = '';
			$contact = '';
		}
		$response = array(
			'id' => $_POST['id'],
			'dealer_id' => $data['dealer_id'],
			'fullname' => $data['fullname'],
			'email' => $data['emailid'],
			'mobile' => $contact,
			'ccode' => str_replace("+","",$ccode),
			'exe_id' => $data['exe_id'],
			'gender' => $data['gender'],
			'dob' => $data['dob'],
			'address' => $data['address'],
		);
		echo json_encode($response);
    }
	public function updateMarketingExecutive()
    {
		$countEmail = $this->model->countData('marketing_executive',['emailid'=>$_POST['emailid'],'id!='=>$_POST['id']]);
		if($countEmail > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		}
		else
		{
			if(isset($_POST['id']))
			{
				$array = array(
					'dealer_id' => $_POST['dealer_id'],
					'fullname' => ucfirst($_POST['fullname']),
					'emailid' => $_POST['emailid'],
					'mobile' =>  '+'.$_POST['ccode'].' '.$_POST['mobile'],
					'exe_id' => $_POST['exe_id'],
					'gender' => $_POST['gender'],
					'dob' => $_POST['dob'],
					'address' => $_POST['address'],
				);
				if($this->model->edit('marketing_executive',$array,['id' => $_POST['id']]))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','marketing executive detail');
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
			else
			{
				echo json_encode(['return'=>false,'msg'=>'`id` is required']);
			}
		}
    }
  

	
}
