<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Department extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Department';
        $page = 'department/index';
        $this->header_and_footer($page, $data);
    }
	public function addDepartment()
    {
		if($_POST['name'])
		{
			$array = array(
				'name' => $_POST['name'],
				'description' => $_POST['description'],
			);
			if($this->model->add('department',$array))
			{
				$lead_id = $this->db->insert_id();
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','department');

				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
			
		}
    }
	public function viewDepartment()
    {
		$data['list'] = $this->model->getResultData('department',[]);
		$this->load->view('department/tb',$data);
    }
	public function editDepartment()
    {
        $response=array();
		$data = $this->model->getRowData('department',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'name' => $data['name'],
			'description' => $data['description'],
		);
		echo json_encode($response);
    }
	public function updateDepartment()
    {
		if(isset($_POST['id']))
		{
			$array = array(
				'name' => $_POST['name'],
				'description' => $_POST['description'],
			);
			if($this->model->edit('department',$array,['id' => $_POST['id']]))
			{
				$lead_id = $_POST['id'];
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','department');
				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
		}
		else
		{
			echo json_encode(['return'=>false,'msg'=>'`id` is required']);
		}
    }
  
   	
}
