<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Company extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Company';
        $page = 'company/index';
        $this->header_and_footer($page, $data);
    }
	public function addCompany()
    {
			if($_POST['company'])
			{
				$array = array(
					'company' => ucfirst($_POST['company']),
					'email' => $_POST['email'],
					'gst' => $_POST['gst'],
					'address' =>  $_POST['address'],
				);
				if($this->model->add('company',$array))
				{
					$lead_id = $this->db->insert_id();
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','company detail');
					
					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
				
			}
    }
	public function viewCompany()
    {
		$data['list'] = $this->model->getResultData('company',['company!='=>'']);
		$this->load->view('company/tb',$data);
    }
	public function editCompany()
    {
        $response=array();
		$data = $this->model->getRowData('company',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'company' => $data['company'],
			'email' => $data['email'],
			'gst' => $data['gst'],
			'address' => $data['address'],
		);
		echo json_encode($response);
    }
	public function updateCompany()
    {
			if(isset($_POST['id']))
			{
				$array = array(
					'company' => ucfirst($_POST['company']),
					'email' => $_POST['email'],
					'gst' => $_POST['gst'],
					'address' =>  $_POST['address']
				);
				if($this->model->edit('company',$array,['id' => $_POST['id']]))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','company detail');

					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
				
			}
    }
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Company Detail';
		$data['data'] = $this->company_model->getCompanyRowData($id);
        $page = 'company/detail';
        $this->header_and_footer($page, $data);
    }

	
	
}
