<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'Auth';
// $route['home'] = 'Website';
$route['subscribe/(:num)'] = 'Website';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

$route['admin'] = 'Auth';
$route['change-password'] = 'Auth/change_pass/';
$route['logout'] = 'Dashboard/logout';
// application/config/routes.php

$route['reset/{$token}'] = 'auth/reset_password';
$route['reset/(:any)'] = 'auth/reset_password/$1';
// application/config/routes.php
$route['auth/process_reset_password'] = 'auth/process_reset_password';
$route['email'] = 'auth/forgotPass';
$route['auth/send_reset_link'] = 'auth/send_reset_link';


// Admin and staff logs
$route['logs'] = 'Admin/logs';

//Staff
$route['staff-login'] = 'Staff_auth';
$route['staff-change-password'] = 'Staff_auth/change_pass/';
$route['staff-detail/(:num)'] = 'Staff/detail';

//Distributor
$route['manage-distributor'] = 'Distributor';
$route['distributor-login'] = 'Distributor_auth';
$route['distributor-change-password'] = 'Distributor_auth/change_pass/';
$route['distributor-detail/(:num)'] = 'Distributor/detail';

//HR
$route['manage-hr'] = 'Hr';
$route['hr-detail/(:num)'] = 'Hr/detail';
$route['hr-login'] = 'Hr_auth';
$route['hr-change-password'] = 'Hr_auth/change_pass/';

// leave management
$route['manage-leave'] = 'Leave';

// attendance management
$route['manage-attendance'] = 'Attendance';
$route['attendance-detail/(:num)'] = 'attendance/detail';

// transaction management
$route['manage-transaction'] = 'Transaction';

// company management
$route['company'] = 'Company';
$route['company-detail/(:num)'] = 'Company/detail';

//customer management
$route['customer'] = 'Customer';
$route['customer-detail/(:num)'] = 'Customer/detail';


//product
$route['unit'] = 'Product/unit';
$route['product-category'] = 'Product/productCategory';
$route['product-detail/(:num)'] = 'Product/detail';
$route['product'] = 'Product';

//order
$route['manage-order'] = 'Order';
$route['order-detail/(:num)'] = 'Order/detail';




