<?php


class Admin_model extends CI_Model
{
    public function getUserRowData($id)
	{
        $query = $this->db
        ->select('t1.*')
        ->from('users t1')
        ->where(['t1.id'=>$id])
        ->get();
		return $query->row_array();
	}
    public function getUserResultData($where)
	{
        $query = $this->db
        ->select('t1.*')
        ->from('users t1');
        if($this->session->userdata('usertype') == 'admin'){
            $this->db->where('t1.id !=', $this->session->userdata('id'));
        }
        
        $query = $this->db->get();
        return $query->result_array();
	}

    public function get_user_id_by_email($email) {
        // Implement the logic to get the user ID by email from the database
        $this->db->select('id');
        $this->db->where('email', $email);
        $query = $this->db->get('users');

        if ($query->num_rows() > 0) {
            return $query->row()->id;
        }

        return false;
    }

    public function save_reset_token($user_id, $token) {
        // Implement the logic to save the reset token in the database
        $data = array('reset_token' => $token);
        $this->db->where('id', $user_id);
        $this->db->update('users', $data);
    }

    public function get_user_id_by_token($token) {
        // Implement the logic to get the user ID by token from the database
        $this->db->select('id');
        $this->db->where('reset_token', $token);
        $query = $this->db->get('users');

        if ($query->num_rows() > 0) {
            return $query->row()->id;
        }

        return false;
    }

    public function update_password_by_token($token, $newPassword) {
        // Check if the token is valid
        $this->db->where('reset_token', $token);
        $query = $this->db->get('users');

        if ($query->num_rows() > 0) {
            $user = $query->row();
            
            // Update the password
            $data = array('password' => $newPassword); 
            $this->db->where('id', $user->id);
            $this->db->update('users', $data);

            // Clear the reset token
            $this->db->where('id', $user->id);
            $this->db->update('users', array('reset_token' => NULL));

            return true; // Password updated successfully
        }

        return false; // Invalid token
    }

    // public function update_password($user_id, $password) {
    //     // Implement the logic to update the user's password in the database
    //     $data = array('password' => password_hash($password, PASSWORD_BCRYPT));
    //     $this->db->where('id', $user_id);
    //     $this->db->update('users', $data);
    // }
}
?>