<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Product extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
		$this->load->library('upload');

		
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Product';
        $data['units'] = $this->model->getResultData('unit',['is_disable'=>0]);
        $data['dealers'] = $this->model->getResultData('distributor',['is_suspended'=>0]);
        $data['categories'] = $this->model->getResultData('product_category',['is_disable'=>0]);
        $page = 'product/index';
        $this->header_and_footer($page, $data);
    }
	public function addProduct()
    {
			if($_POST['name'])
			{
				$array = array(
					'name' => $_POST['name'],
					'dealer_id' => $_POST['dealer_id'],
					'category_id' => $_POST['category_id'],
					'hsn' => $_POST['hsn'],
					'mrp' => $_POST['mrp'],
					'unit_id' => $_POST['unit_id'],
					'description' => $_POST['description'],
				);
				if($this->product_model->addProduct($array))
				{
					$lead_id = $this->db->insert_id();
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','Product detail');

					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
				
			}
				
        
	}
		public function productImage()
    {
		$data['list'] = $this->product_model->productImage($_POST['product_id']);
    }
	public function deleteProductImage()
    {
        if(isset($_POST['image_id']))
		{
			if($this->product_model->deleteProductImage($_POST['image_id']))
			{
				$lead_id = $_POST['image_id'];
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','product image');
				echo json_encode(['return'=>true,'msg'=>'Image Deleted Successfully']);
			}
		}
    }
	public function addProductImage()
    {
        if($_POST['product_id'])
		{
			if($this->product_model->addProductImage($_POST['product_id']))
			{
				$lead_id = $this->db->insert_id();
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','product image');
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
		}
    }
	public function makeProductCoverImage()
    {
        if(isset($_POST['image_id']))
		{
			if($this->model->edit('product_image',['is_cover'=>0],['product_id'=>$_POST['product_id']]))
			{
				$this->model->edit('product_image',['is_cover'=>1],['id'=>$_POST['image_id']]);
				
				echo json_encode(['return'=>true,'msg'=>'Cover Updated Successfully']);
			}
		}
    }	
	
	public function viewProduct()
    {
		$data['list'] = $this->model->getResultData('product',[]);
		$this->load->view('product/tb',$data);
    }
	public function editProduct()
    {
        $response=array();
		$data = $this->model->getRowData('product',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'name' => $data['name'],
			'hsn' => $data['hsn'],
			'dealer_id' => $data['dealer_id'],
			'category_id' => $data['category_id'],
			'mrp' => $data['mrp'],
			'unit_id' => $data['unit_id'],
			'description' => $data['description']
			
		);
		echo json_encode($response);
    }        
	public function updateProduct()
    {
			if(isset($_POST['id']))
			{
				$array = array(
					'name' =>$_POST['name'],
					'hsn' => $_POST['hsn'],
					'dealer_id' => $_POST['dealer_id'],
					'category_id' => $_POST['category_id'],
					'mrp' => $_POST['mrp'],
					'unit_id' => $_POST['unit_id'],
					'description' => $_POST['description'],
				);
				if($this->product_model->updateProduct($array,$_POST['id']))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','Product detail');
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
			else
			{
				echo json_encode(['return'=>false,'msg'=>'`id` is required']);
			}
			
		
    }
  
   
	public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Product Detail';
		$data['data'] = $this->product_model->getProductRowData($id);
		// echo "<pre>";print_r($data['data']);exit();
        $page = 'product/detail';
        $this->header_and_footer($page, $data);
    }


	
//Product Category management
public function productCategory()
{
	$data['title'] = 'Product Category';
	$page = 'product_category/index';
	$this->header_and_footer($page, $data);
}
public function addProductCategory()
{
	if($_POST['name'])
	{
		$countName = $this->model->countData('product_category',['name'=>$_POST['name']]);
		if($countName > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Product already exist']);
		}
		else
		{
			$array = array(
				'name' => $_POST['name'],
				'description' => $_POST['description'],
			);
			if($this->product_model->addProductCategory($array))
			{
				$lead_id = $this->db->insert_id();
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','product category');
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
		}
	}
}
public function viewProductCategory()
{
	$data['list'] = $this->model->getResultData('product_category',[],null,'id','DESC');
	$this->load->view('product_category/tb',$data);
}
public function editProductCategory()
{
	$data = $this->model->getRowData('product_category',['id'=>$_POST['id']]);
	$response = array(
		'id' => $_POST['id'],
		'name' => $data['name'],
		'description' => $data['description'],
		'icon' => base_url('assets/uploads/'.$data['icon'].''),
		'banner' => base_url('assets/uploads/'.$data['banner'].''),
	);
	echo json_encode($response);
}
public function updateProductCategory()
{
	if(isset($_POST['id']))
	{
		$countName = $this->model->countData('product_category',['name'=>$_POST['name'],'id!='=>$_POST['id']]);
		if($countName > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Product already exist']);
		}
		else
		{
			$array = array(
				'name' => $_POST['name'],
				'description' => $_POST['description'],
			);
			if($this->product_model->updateProductCategory($array,$_POST['id']))
			{
				$lead_id = $_POST['id'];
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','product category');
				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
		}
	}
}

//Manage unit
	public function unit()
    {
        $data['title'] = 'Unit';
        $page = 'unit/index';
        $this->header_and_footer($page, $data);
    }
	public function addUnit()
    {
			if($_POST['name'])
			{
				$array = array(
					'name' => $_POST['name'],
				);
				if($this->model->add('unit',$array))
				{
					$lead_id = $this->db->insert_id();
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','Unit detail');

					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
				
			}
				
        
	}
			
	
	public function viewUnit()
    {
		$data['list'] = $this->model->getResultData('unit',[]);
		$this->load->view('unit/tb',$data);
    }
	public function editUnit()
    {
        $response=array();
		$data = $this->model->getRowData('unit',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'name' => $data['name'],
		);
		echo json_encode($response);
    }        
	public function updateUnit()
    {
			if(isset($_POST['id']))
			{
				$array = array(
					'name' =>$_POST['name'],
				);
				if($this->model->edit('unit',$array,['id'=>$_POST['id']]))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','Unit detail');
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
			else
			{
				echo json_encode(['return'=>false,'msg'=>'`id` is required']);
			}
			
		
    }
	
}
