<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Leave extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
		$this->load->library('upload');

		
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Leave';
        $data['staffs'] = $this->model->getResultData('staff',['is_suspended'=>0]);
        $page = 'leave/index';
        $this->header_and_footer($page, $data);
    }
	
	
	public function addLeave()
	{
		if($_POST['leave_type'])
		{
			$array = array(
				'staff_id' => $_POST['staff_id'],
				'leave_type' => $_POST['leave_type'],
				'from_date' => $_POST['from_date'],
				'to_date' => $_POST['to_date'],
				'description' => $_POST['description'],
			);
			if($this->model->add('leave',$array))
			{
				$lead_id = $this->db->insert_id();
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','apply leave');
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
		}
	}
	public function viewLeave()
	{
		$data['list'] = $this->model->getResultData('leave',[],null,'id','DESC');
		$this->load->view('leave/tb',$data);
	}
	public function editLeave()
	{
		$data = $this->model->getRowData('leave',['id'=>$_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'staff_id' => $data['staff_id'],
			'leave_type' => $data['leave_type'],
			'from_date' => $data['from_date'],
			'to_date' => $data['to_date'],
			'description' => $data['description'],
		);
		echo json_encode($response);
	}
	public function updateLeave()
	{
		if(isset($_POST['id']))
		{
			$array = array(
				'staff_id' => $_POST['staff_id'],
				'leave_type' => $_POST['leave_type'],
				'from_date' => $_POST['from_date'],
				'to_date' => $_POST['to_date'],
				'description' => $_POST['description'],
			);
			if($this->model->edit('leave',$array,['id'=>$_POST['id']]))
			{
				$lead_id = $_POST['id'];
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','leave detail');
				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
		}
	}
	
}
