<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Product extends CI_Controller {

    public function viewProducts()   //with or without category id and dealer id
    {
        if(isset($_REQUEST['api_key']) && $_REQUEST['api_key']!=='')
	    {
    	    if($_REQUEST['api_key'] == get_setting()['api_key'])
    	    {
                $category_id = null;$dealer_id = null;
                if(isset($_REQUEST['category_id']) && $_REQUEST['category_id']!=='')
                {
                    $category_id = $_REQUEST['category_id'];
                }
                if(isset($_REQUEST['dealer_id']) && $_REQUEST['dealer_id']!=='')
                {
                    $dealer_id = $_REQUEST['dealer_id'];
                }
                $response = [];
                $list = $this->api_model->getProductResultData($category_id,$dealer_id);
                foreach($list as $key => $val)
                {
                    $array = array(
                        'id' => $val['id'],
                        'dealer_id' => $val['dealer_id'],
                        'dealer_name' => $val['dealer_name'],
                        'category_id' => $val['category_id'],
                        'category_name' => $val['category_name'],
                        'product_name' => $val['name'],
                        'description' => $val['description'],
                        'hsn' => $val['hsn'],
                        'mrp' => $val['mrp'],
                        'unit' => $val['unit_name'],
                        'created' => date('d-m-Y',strtotime($val['created'])),
                    );
                   
                    array_push($response,$array);
                }
                echo json_encode(['return'=>true,'list'=>$response]);
    	    }
    	    else
    		{
                echo json_encode(['return'=>false,'msg'=>'Invalid Api key']);
    		}
	    }
	    else
		{
            echo json_encode(['return'=>false,'msg'=>'`api_key` is required']);
		}
    }

    public function productById()
    {
        if(isset($_REQUEST['api_key']) && $_REQUEST['api_key']!=='')
	    {
    	    if($_REQUEST['api_key'] == get_setting()['api_key'])
    	    {
                if(isset($_REQUEST['product_id']) && $_REQUEST['product_id']!=='')
	            {
                    $response = [];
                    $val = $this->api_model->getProductRowData($_REQUEST['product_id']);
                    $array = array(
                        'id' => $val['id'],
                        'dealer_id' => $val['dealer_id'],
                        'dealer_name' => $val['dealer_name'],
                        'category_id' => $val['category_id'],
                        'category_name' => $val['category_name'],
                        'product_name' => $val['name'],
                        'description' => $val['description'],
                        'hsn' => $val['hsn'],
                        'mrp' => $val['mrp'],
                        'unit' => $val['unit_name'],
                        'created' => date('d-m-Y',strtotime($val['created'])),
                    );
                    
                    array_push($response,$array);
                    echo json_encode(['return'=>true,'list'=>$response]);
                }
                else
                {
                    echo json_encode(['return'=>false,'msg'=>'`product_id` is required']);
                }
    	    }
    	    else
    		{
                echo json_encode(['return'=>false,'msg'=>'Invalid Api key']);
    		}
	    }
	    else
		{
            echo json_encode(['return'=>false,'msg'=>'`api_key` is required']);
		}
    }


    
}
