<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Order extends CI_Controller {

    public function placeOrder()
    {
        if(isset($_POST['api_key']) && $_POST['api_key']!=='')
	    {
    	    if($_POST['api_key'] == get_setting()['api_key'])
    	    {
				if(isset($_POST['customer_id']) && $_POST['customer_id']!=='')
	    		{	
                    if($this->model->countData('orders',[]) > 0){
                        $number = $this->model->getRowData('orders',[],null,'id','DESC')['id'] + 1;
                        $number = sprintf('%03d',$number);
                    }else{
                        $number = sprintf('%03d',1);
                    }
                    $order_no = 'INTIMAOD'.$number;
                    $array = array(
                        'order_no' => $order_no,
                        'customer_id' => $_POST['customer_id'],
                        'category_id' => $_POST['category_id'],
                        'product_id' => $_POST['product_id'],
                        'design_no' => $_POST['design_no'],
                        'operating_side' => $_POST['operating_side'],
                        'motor_side' => $_POST['motor_side'],
                        'chain_size' => $_POST['chain_size'],
                        'size_type' => $_POST['size_type'],
                        'width' => $_POST['width'],
                        'height' => $_POST['height'],
                        'quantity' => $_POST['quantity'],
                        'notes' => $_POST['notes'],
                    );
                    if($this->model->add('orders',$array))
                    {
                        echo json_encode(['return'=>true,'msg'=>'Added successfully..']);
                    }
				}
				else
				{
					echo json_encode(['return'=>false,'msg'=>'customer_id is required']);
				}
    	    }
    	    else
    		{
                echo json_encode(['return'=>false,'msg'=>'Invalid Api key']);
    		}
	    }
	    else
		{
            echo json_encode(['return'=>false,'msg'=>'`api_key` is required']);
		}
    }
    public function orderDetail()
    {
        if(isset($_REQUEST['api_key']) && $_REQUEST['api_key']!=='')
	    {
    	    if($_REQUEST['api_key'] == get_setting()['api_key'])
    	    {
                if(isset($_REQUEST['order_id']) && $_REQUEST['order_id']!=='')
	            {
                    $response = [];
                    $val = $this->api_model->getOrderRowData($_REQUEST['order_id']);
                    $array = array(
                        'id' => $val['id'],
                        'order_no' => $val['order_no'],
                        'dealer_id' => $val['dealer_id'],
                        'dealer_name' => $val['dealer_name'],
                        'customer_id' => $val['customer_id'],
                        'customer_name' => $val['customer_name'],
                        'category_id' => $val['category_id'],
                        'category_name' => $val['category_name'],
                        'product_id' => $val['product_id'],
                        'product_name' => $val['product_name'],
                        'design_no' => $val['design_no'],
                        'operating_side' => $val['operating_side'],
                        'motor_side' => $val['motor_side'],
                        'chain_size' => $val['chain_size'],
                        'size_type' => $val['size_type'],
                        'width' => $val['width'],
                        'height' => $val['height'],
                        'quantity' => $val['quantity'],
                        'notes' => $val['notes'],
                        'status' => $val['status'],
                        'created' => date('d-m-Y',strtotime($val['created'])),
                    );
                    
                    array_push($response,$array);
                    echo json_encode(['return'=>true,'list'=>$response]);
                }
                else
                {
                    echo json_encode(['return'=>false,'msg'=>'`order_id` is required']);
                }
    	    }
    	    else
    		{
                echo json_encode(['return'=>false,'msg'=>'Invalid Api key']);
    		}
	    }
	    else
		{
            echo json_encode(['return'=>false,'msg'=>'`api_key` is required']);
		}
    }
    public function orderList()     //with or without customer / dealer
    {
        if(isset($_REQUEST['api_key']) && $_REQUEST['api_key']!=='')
	    {
    	    if($_REQUEST['api_key'] == get_setting()['api_key'])
    	    {
                $dealer_id = null;$customer_id = null;
                if(isset($_REQUEST['dealer_id']) && $_REQUEST['dealer_id']!=='')
                {
                    $dealer_id = $_REQUEST['dealer_id'];
                }
                if(isset($_REQUEST['customer_id']) && $_REQUEST['customer_id']!=='')
                {
                    $customer_id = $_REQUEST['customer_id'];
                }
                $response = [];
                $list = $this->api_model->getOrderResultData($customer_id,$dealer_id);
                foreach($list as $val){
                    $array = array(
                        'id' => $val['id'],
                        'dealer_id' => $val['dealer_id'],
                        'dealer_name' => $val['dealer_name'],
                        'customer_id' => $val['customer_id'],
                        'customer_name' => $val['customer_name'],
                        'category_id' => $val['category_id'],
                        'category_name' => $val['category_name'],
                        'product_id' => $val['product_id'],
                        'product_name' => $val['product_name'],
                        'design_no' => $val['design_no'],
                        'operating_side' => $val['operating_side'],
                        'motor_side' => $val['motor_side'],
                        'chain_size' => $val['chain_size'],
                        'size_type' => $val['size_type'],
                        'width' => $val['width'],
                        'height' => $val['height'],
                        'quantity' => $val['quantity'],
                        'notes' => $val['notes'],
                        'status' => $val['status'],
                        'created' => date('d-m-Y',strtotime($val['created'])),
                    );
                    array_push($response,$array);
                }
                
                echo json_encode(['return'=>true,'list'=>$response]);
    	    }
    	    else
    		{
                echo json_encode(['return'=>false,'msg'=>'Invalid Api key']);
    		}   
	    }
	    else
		{
            echo json_encode(['return'=>false,'msg'=>'`api_key` is required']);
		}
    }
    public function orderImages()
    {
        if(isset($_REQUEST['api_key']) && $_REQUEST['api_key']!=='')
	    {
    	    if($_REQUEST['api_key'] == get_setting()['api_key'])
    	    {
                if(isset($_REQUEST['order_id']) && $_REQUEST['order_id']!=='')
	            {
                    $response = [];
                    $list = $this->model->getResultData('order_image',['order_id'=>$_REQUEST['order_id']]);
                    if(!empty($list)){
                        foreach($list as $val){
                            $array = array(
                                'id' => $val['id'],
                                'order_id' => $val['order_id'],
                                'image' => base_url('assets/uploads/'.$val['image'].''),
                                'created' => date('d-m-Y',strtotime($val['created'])),
                            );
                            array_push($response,$array);
                        }
                        
                        echo json_encode(['return'=>true,'list'=>$response]);
                    }else{
                        echo json_encode(['return'=>false,'msg'=>'No images found']);
                    }
                    
                }
                else
                {
                    echo json_encode(['return'=>false,'msg'=>'`order_id` is required']);
                }
    	    }
    	    else
    		{
                echo json_encode(['return'=>false,'msg'=>'Invalid Api key']);
    		}
	    }
	    else
		{
            echo json_encode(['return'=>false,'msg'=>'`api_key` is required']);
		}
    }
    public function holdOrder()
    {
        if(isset($_POST['api_key']) && $_POST['api_key']!=='')
	    {
    	    if($_POST['api_key'] == get_setting()['api_key'])
    	    {
				if(isset($_POST['order_id']) && $_POST['order_id']!=='')
	    		{	
                    if($this->model->edit('orders',['status'=>'onhold'],['id'=>$_POST['order_id']]))
                    {
                        echo json_encode(['return'=>true,'msg'=>'Order hold successfully..']);
                    }
				}
				else
				{
					echo json_encode(['return'=>false,'msg'=>'order_id is required']);
				}
    	    }
    	    else
    		{
                echo json_encode(['return'=>false,'msg'=>'Invalid Api key']);
    		}
	    }
	    else
		{
            echo json_encode(['return'=>false,'msg'=>'`api_key` is required']);
		}
    }
    public function approveOrder()
    {
        if(isset($_POST['api_key']) && $_POST['api_key']!=='')
	    {
    	    if($_POST['api_key'] == get_setting()['api_key'])
    	    {
				if(isset($_POST['order_id']) && $_POST['order_id']!=='')
	    		{	
                    if($this->model->edit('orders',['status'=>'approved'],['id'=>$_POST['order_id']]))
                    {
                        echo json_encode(['return'=>true,'msg'=>'Order approved successfully..']);
                    }
				}
				else
				{
					echo json_encode(['return'=>false,'msg'=>'order_id is required']);
				}
    	    }
    	    else
    		{
                echo json_encode(['return'=>false,'msg'=>'Invalid Api key']);
    		}
	    }
	    else
		{
            echo json_encode(['return'=>false,'msg'=>'`api_key` is required']);
		}
    }


    
}
