<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Distributor extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Dealer';
		//generate distributor id
		if($this->model->countData('distributor',[]) > 0){
			$number = $this->model->getRowData('distributor',[],null,'id','DESC')['id'] + 1;
			$number = sprintf('%03d',$number);
			$data['distributorId'] = 'DIST'.$number;
		}else{
			$data['distributorId'] = 'DIST'.sprintf('%03d',1);
		}
		$data['countries'] = $this->model->getResultData('countries',[]);
        $page = 'distributor/index';
        $this->header_and_footer($page, $data);
    }
	public function addDistributor()
    {
		$countEmail = $this->model->countData('distributor',['emailid'=>$_POST['emailid']]);
		if($countEmail > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		}
		else
		{
			if($_POST['fullname'])
			{
				$array = array(
					'fullname' => ucfirst($_POST['fullname']),
					'emailid' => $_POST['emailid'],
					'password' =>md5($_POST['password']),
					'mobile' =>  '+'.$_POST['ccode'].' '.$_POST['mobile'],
					'country' => $_POST['country'],
					'state' => $_POST['state'],
					'city' => $_POST['city'],
					'distributor_id' => $_POST['distributor_id'],
					'pincode' => $_POST['pincode'],
					'gender' => $_POST['gender'],
					'dob' => $_POST['dob'],
					'address' => $_POST['address'],
				);
				if($this->model->add('distributor',$array))
				{
					$lead_id = $this->db->insert_id();
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','distributor detail');

					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
				
			}
		}
    }
	public function viewDistributor()
    {
		$data['list'] = $this->model->getResultData('distributor',[]);
		$this->load->view('distributor/tb',$data);
    }
	public function editDistributor()
    {
        $response=array();
		$data = $this->model->getRowData('distributor',['id' => $_POST['id']]);
		if($data['mobile'] !== '')
		{
			$mob = explode(' ',$data['mobile']);
			$ccode = $mob[0];
			$contact = $mob[1];
		}else{
			$mob = '';
			$ccode = '';
			$contact = '';
		}
		$response = array(
			'id' => $_POST['id'],
			'fullname' => $data['fullname'],
			'email' => $data['emailid'],
			'mobile' => $contact,
			'ccode' => str_replace("+","",$ccode),
			'password' => $data['password'],
			'country' => $data['country'],
			'state' => $data['state'],
			'city' => $data['city'],
			'distributor_id' => $data['distributor_id'],
			'pincode' => $data['pincode'],
			'gender' => $data['gender'],
			'dob' => $data['dob'],
			'address' => $data['address'],
		);
		echo json_encode($response);
    }
	public function updateDistributor()
    {
		$countEmail = $this->model->countData('distributor',['emailid'=>$_POST['emailid'],'id!='=>$_POST['id']]);
		if($countEmail > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		}
		else
		{
			if(isset($_POST['id']))
			{
				$array = array(
					'fullname' => ucfirst($_POST['fullname']),
					'emailid' => $_POST['emailid'],
					'mobile' =>  '+'.$_POST['ccode'].' '.$_POST['mobile'],
					'country' => $_POST['country'],
					'state' => $_POST['state'],
					'city' => $_POST['city'],
					'distributor_id' => $_POST['distributor_id'],
					'pincode' => $_POST['pincode'],
					'gender' => $_POST['gender'],
					'dob' => $_POST['dob'],
					'address' => $_POST['address'],
				);
				if($this->model->edit('distributor',$array,['id' => $_POST['id']]))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','distributor detail');
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
			else
			{
				echo json_encode(['return'=>false,'msg'=>'`id` is required']);
			}
		}
    }
  
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Distributor Detail';
		$data['data'] = $this->distributor_model->getDistributorRowData($id);
        $page = 'distributor/detail';
        $this->header_and_footer($page, $data);
    }
    

	public function changePassword()
    {
        if($_POST['id'])
		{
			if($this->model->edit('distributor',['password'=>md5($_POST['password'])],['id' => $_POST['id']]))
			{
				$this->viewDistributor();
			}
			
		}
    }
	
}
