<script>
    $(document).ready(function() {
      if($('#usertype').val() == 'admin'){
        $('#mytable').DataTable({
          dom: 'Bfrtip',
          ordering: false,
        buttons: [
          // { extend: 'pdf', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3]}, },
          // { extend: 'excel', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3]}, },
          // { extend: 'csv', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3]}, },
        ]});
      }else{
        $('#mytable').DataTable();
      }
        if($('#usertype').val() == 'staff')
    {
        $('.edit-btn').remove();
        $('.add-btn').remove();
    }
    } );
</script>
<table class="table table-bordered" id="mytable">
  <thead>
    <tr>
      <th scope="col">Lead No.</th>
      <th scope="col">Staff</th>
      <th scope="col">Leave type</th>
      <th scope="col">From Date</th>
      <th scope="col">To Date</th>
      <th scope="col">Leave count</th>
      <th scope="col">Status</th>
      <th scope="col">Description</th>
      <th scope="col">Applied Date</th>
      <th scope="col">Action</th>
    </tr>
  </thead>
  <tbody>
    <?php $i=1; foreach($list as $val){
      $staffData = $this->model->getRowData('staff',['id'=>$val['staff_id']]);
      if($staffData){
        $staff_name = $staffData['fullname'];
      }else{
        $staff_name = '';
      }
      ?>
    <tr>
      <th scope="row"><?= $val['id']; ?></th>
      <td><?= $staff_name; ?></td>
      <td><?= $val['leave_type']; ?></td>
      <td><?= date('d-m-Y',strtotime($val['from_date']));?></td>
      <td><?= date('d-m-Y',strtotime($val['to_date']));?></td>
      <td><?= countDaysBetweenDates(date('d-m-Y',strtotime($val['from_date'])),date('d-m-Y',strtotime($val['to_date']))); ?></td>
      <td>
        <?php
            if($val['is_approved'] == 0){
              echo "<b class='text-info'>Pending</b>";
            }else if($val['is_approved'] == 1){
              echo "<b class='text-success'>Approved</b>";
            }else if($val['is_approved'] == 2){
              echo "<b class='text-danger'>Rejected</b>";
            }
        ?>
      </td>
      <td><?= $val['description']; ?></td>
      <td><?= date('d-m-Y',strtotime($val['created']));?></td>
      <td>
        <a href="javascript:void(0)" class="btn btn-primary btn-sm edit-btn"  onclick="editLeave(<?= $val['id']; ?>)" data-bs-toggle="modal" data-bs-target="#editModal" data-bs-original-title="Edit Product">Edit</a>
        <?php if($this->session->userdata('usertype')!=='staff'){ ?>
        <?php if($val['is_disable'] == '0'){ ?>
            <a href="javascript:void(0)" class="btn btn-danger btn-sm disable-btn" onclick="changeStatus(<?= $val['id']; ?>,'1')">Disable</a>
        <?php } else{ ?>
            <a href="javascript:void(0)" class="btn btn-success btn-sm disable-btn" onclick="changeStatus(<?= $val['id']; ?>,'0')">Enable</a>
        <?php } ?>

        <?php if($val['is_approved'] == '0' || $val['is_approved'] == '2'){ ?>
            <a href="javascript:void(0)" class="btn btn-success btn-sm disable-btn" onclick="changeLeaveStatus(<?= $val['id']; ?>,'1')">Approve</a>
        <?php } else{ ?>
            <a href="javascript:void(0)" class="btn btn-secondary btn-sm disable-btn" onclick="changeLeaveStatus(<?= $val['id']; ?>,'2')">Reject</a>
        <?php } ?>
        <?php } ?>
          
      </td>
    </tr>
    <?php } ?>
  </tbody>
</table>
<script>

function changeStatus(id,type)
{
  if (confirm('Are you sure?') == true) {
    var table = 'leave';
    var column = 'is_disable';
    $.ajax({
        url: "<?= base_url('Dashboard/Status'); ?>",
        method: "POST",
        data: {
            id:id,
            type:type,
            table:table,
            column:column,
            module:'apply leave'
        },
        dataType:'json',
        success:function(res){
          if(res.return)
          {
            $('#tb').load('<?= base_url('leave/viewLeave'); ?>');
            toastr.success(res.msg);
          }
          else
          {
            toastr.error(res.msg);
          }
        }
    });
  }
};
function changeLeaveStatus(id,type)
{
  if (confirm('Are you sure?') == true) {
    var table = 'leave';
    var column = 'is_approved';
    $.ajax({
        url: "<?= base_url('Dashboard/changeLeaveStatus'); ?>",
        method: "POST",
        data: {
            id:id,
            type:type,
            table:table,
            column:column,
            module:'leave status'
        },
        dataType:'json',
        success:function(res){
          if(res.return)
          {
            $('#tb').load('<?= base_url('leave/viewLeave'); ?>');
            toastr.success(res.msg);
          }
          else
          {
            toastr.error(res.msg);
          }
        }
    });
  }
}; 
</script>