        <div class="page-body">
          <div class="container-fluid">
            <div class="page-title">
              <div class="row">
                <div class="col-6">
                  <h3><?= $title; ?></h3>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid starts-->
          <div class="container-fluid">
            <div class="row">
              <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                  <div class="row">
                  <div class="col-sm-6">
                    <h5><?= $title; ?></h5>
                  </div>
                  <div class="col-sm-6 text-right">
                    <button class="btn btn-success rounded add-btn" type="button" onclick="add()"><i class="fa fa-plus"></i> Add <?= $title; ?></button>
                   </div>
                 </div>
                  </div>
                  <div class="card-body">
                    <div class="table-responsive" id="tb">
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid Ends-->
        </div>
        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="add-form">
                  <div class="row g-2">
                    <div class="mt-0 col-md-12">
                      <p id="error"></p>
                    </div>
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Fullname <span class="text-danger">*</span></label>
                      <input class="form-control" id="fullname" type="text" name="fullname" required>
                    </div>
                     <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Country Code <span class="text-danger">*</span></label>
                        <select class="form-control select2" name="ccode"  id="ccode" required>
                            <option value="">Select</option>
                            <?php foreach (getCountryWithPhoneCode() as $ccodekey => $ccodevalue): ?>
                                <option data-atr="<?= $ccodevalue['code'].' +'.$ccodevalue['phone']?>" data-ctr="<?= $ccodevalue['name'].' (+'.$ccodevalue['phone'].')' ?>" value="<?= $ccodevalue['phone'] ?>"><?= $ccodevalue['name'].' (+'.$ccodevalue['phone'].')' ?></option>
                            <?php endforeach ?>   
                        </select>
                      </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Mobile <span class="text-danger">*</span></label>
                      <input name="mobile"  id="mobile" class="form-control" type="text" pattern="[1-9]{1}[0-9]{9}" title="Enter 10 digit contact number" placeholder="Mobile number" maxlength="10"  required>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Business name</label>
                      <input class="form-control" id="business_name" type="text" name="business_name">
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">GST</label>
                      <input class="form-control" id="gst" type="text" name="gst">
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Email <span class="text-danger">*</span></label>
                      <input class="form-control" id="emailid" name="emailid" type="email" name="email" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Password <span class="text-danger">*</span></label>
                      <input class="form-control" id="password" type="password" name="password" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Distributor ID <span class="text-danger">*</span></label>
                      <input class="form-control" id="distributor_id" type="text" name="distributor_id" 
                      value="<?= $distributorId ?>" readonly
                      required>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Pincode</label>
                      <input class="form-control" id="pincode" name="pincode" type="text" pattern="^[1-9][0-9]{5}$" title="minimum 6 digits are allowed" maxlength="6">
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Gender</label>
                      <select class="form-control" id="gender" name="gender">
                          <option value="">Select</option>
                          <option value="Male">Male</option>
                          <option value="Female">Female</option>
                          <option value="Other">Other</option>
                      </select>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Date of Birth</label>
                      <input class="form-control" id="dob" type="date" name="dob" max="<?= date('Y-m-d',strtotime("-1 days")); ?>">
                    </div>
                    <div class="mb-3 mt-0 col-md-4">
                      <label for="bm-title">Country</label>
                      <select name="country" class="form-control" id="country" onchange="fetch_state(this.value)">
                          <option value="">Select Country</option>
                          <?php foreach($countries as $country){ ?>
                            <option value="<?= $country['id']; ?>" required><?= $country['name']; ?></option>
                          <?php } ?>
                      </select>                   
                    </div>
                    <div class="mb-3 mt-0 col-md-4">
                      <label for="bm-title">State</label>
                      <select name="state" class="state form-control" id="state" onchange="fetch_city(this.value)">
                      </select>                    
                    </div>
                    <div class="mb-3 mt-0 col-md-4">
                      <label for="bm-title">City</label>
                      <select name="city" class="city form-control" id="city">
                      </select>                 
                    </div>
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Address</label>
                      <textarea class="form-control" id="address" name="address"></textarea>
                    </div>
                    
                  </div>
                  <button class="btn btn-secondary" type="submit">Add</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>

        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Edit <?= $title; ?></h5>
      <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
    </div>
    <div class="modal-body">
    <form class="form-bookmark" id="edit-form">
        <div class="row g-2">
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Fullname <span class="text-danger">*</span></label>
              <input class="form-control" name="fullname" id="efullname" type="text" required="">
            </div>
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Country Code <span class="text-danger">*</span></label>
              <select class="form-control select2" name="ccode"  id="e_ccode" required>
                  <option value="">Select</option>
                  <?php foreach (getCountryWithPhoneCode() as $ccodekey => $ccodevalue): ?>
                      <option data-atr="<?= $ccodevalue['code'].' +'.$ccodevalue['phone']?>" data-ctr="<?= $ccodevalue['name'].' (+'.$ccodevalue['phone'].')' ?>" value="<?= $ccodevalue['phone'] ?>"><?= $ccodevalue['name'].' (+'.$ccodevalue['phone'].')' ?></option>
                  <?php endforeach ?>   
              </select>
            </div>
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Mobile <span class="text-danger">*</span></label>
              <input name="mobile"  id="e_mobile" class="form-control" type="text" pattern="[1-9]{1}[0-9]{9}" title="Enter 10 digit mobile number" placeholder="Mobile number" required >
            </div>
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Business name</label>
              <input class="form-control" id="e_business_name" type="text" name="business_name">
            </div>
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">GST</label>
              <input class="form-control" id="e_gst" type="text" name="gst">
            </div>
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Email <span class="text-danger">*</span></label>
              <input class="form-control" id="eemailid" name="emailid" type="email" required="">
            </div>
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Gender </label>
              <select class="form-control" id="e_gender" name="gender">
                  <option value="">Select</option>
                  <option value="Male">Male</option>
                  <option value="Female">Female</option>
                  <option value="Other">Other</option>
              </select>
            </div>
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Date of Birth</label>
              <input class="form-control" id="e_dob" type="date" name="dob" max="<?= date('Y-m-d',strtotime("-1 days")); ?>">
            </div>
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Distributor ID <span class="text-danger">*</span></label>
              <input class="form-control" id="e_distributor_id" type="text" name="distributor_id" readonly required>
            </div>
            <div class="mb-3 mt-0 col-md-6">
              <label for="bm-title">Pincode</label>
              <input class="form-control" id="e_pincode" name="pincode" type="text" pattern="^[1-9][0-9]{5}$" title="minimum 6 digits are allowed" maxlength="6">
            </div>
            <div class="mb-3 mt-0 col-md-4">
              <label for="bm-title">Country</label>
                <select name="country" class="form-control" id="e_country" onchange="fetch_state(this.value)">
                    <option value="">Select Country</option>
                    <?php foreach($countries as $country){ ?>
                      <option value="<?= $country['id']; ?>" required><?= $country['name']; ?></option>
                    <?php } ?>
                </select>                     
            </div>
            <div class="mb-3 mt-0 col-md-4">
              <label for="bm-title">State</label>
              <select name="state" class="state form-control" id="e_state" onchange="fetch_city(this.value)">
                  <option value="">Select State</option>
              </select>                    
            </div>
            <div class="mb-3 mt-0 col-md-4">
              <label for="bm-title">City</label>
              <select name="city" class="city form-control" id="e_city">
                  <option value="">Select City</option>
              </select>                 
            </div>
            <div class="mb-3 mt-0 col-md-12">
              <label for="bm-title">Address</label>
              <textarea class="form-control" id="e_address" name="address"></textarea>
            </div>
        </div>
        <input type="hidden" id="e_id" name="id">
        <button class="btn btn-secondary" type="submit">Update</button>
        <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
    </form>
    </div>
  </div>
</div>
        </div>
<!-- Modal -->
      <div class="modal fade modal-bookmark" id="changePasswordModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="exampleModalLabel">Change Password</h5>
              <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <form class="form-bookmark" id="change-password-form">
                <div class="row g-2">
                  <div class="mb-3 mt-0 col-md-6">
                    <label for="bm-title">New Password</label>
                    <input class="form-control" id="new_password" type="password" required="">
                  </div>
                  <div class="mb-3 mt-0 col-md-6">
                    <label for="bm-title">Confirm Password</label>
                    <input class="form-control" id="confirm_password" type="password" required="">
                  </div>
                  <input type="hidden" id="distributor_id">
                </div>
                <button class="btn btn-secondary submit-btn" type="submit">Save</button>
                <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
              </form>
            </div>
          </div>
        </div>
      </div>
<script>
  function add()
  {
    $('#addModal').modal('toggle'); 
    $('#add-form')[0].reset();
    $('#city').find('option:not(:first)').remove();
    $('#state').find('option:not(:first)').remove();
  }
$(document).ready(function(){
  $('#addModal').modal({
           backdrop: 'static',
           keyboard: false
    })
    $('#editModal').modal({
           backdrop: 'static',
           keyboard: false
    })
  $('#tb').load('<?= base_url('distributor/viewDistributor'); ?>');
});


$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('distributor/addDistributor'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#addModal').modal('toggle'); 
          $('#add-form')[0].reset();
          $('#tb').load('<?= base_url('distributor/viewDistributor'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
})
function editDistributor(id)
{
  $.ajax({
      url: "<?= base_url('distributor/editDistributor'); ?>",
      method: "POST",
        dataType: 'json',
      data: {
          id:id
      },
      success:function(res){
          fetch_state(res.country,res.state);
          fetch_city(res.state,res.city);
          $("#e_id").val(res.id);
          $("#efullname").val(res.fullname);
          $("#eemailid").val(res.email);
          $("#e_mobile").val(res.mobile);
          $("#e_business_name").val(res.business_name);
          $("#e_gst").val(res.gst);
          $("#e_ccode option[value='"+res.ccode+"']").attr("selected", "selected");
          $("#e_distributor_id").val(res.distributor_id);
          $("#e_pincode").val(res.pincode);
          $("#e_gender option[value='"+res.gender+"']").attr("selected", "selected");
          $("#e_dob").val(res.dob);
          $("#e_address").val(res.address);
          $("#e_country option[value='"+res.country+"']").attr("selected", "selected");
      }
  });
};
$("#edit-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('distributor/updateDistributor'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
  
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#editModal').modal('toggle'); 
          $('#tb').load('<?= base_url('distributor/viewDistributor'); ?>');
          toastr.success(res.msg);
        }
        else
        {          
          toastr.error(res.msg);
        }
      }
  });
})

  function fetch_state(country_id,state_id) {
    $.ajax({
      url: "<?= base_url('dashboard/fetch_state'); ?>",
      method: "POST",
      data: {
        country_id: country_id,
        state_id: state_id
      },
      success: function(data) {
        if(state_id == null)
        {
          $(".state").html(data);
        }
        else
        {
          $("#e_state").html(data);
        }
      },
    });
  }
  function fetch_city(state_id,city_id) {
    $.ajax({
      url: "<?= base_url('dashboard/fetch_city'); ?>",
      method: "POST",
      data: {
        state_id: state_id,
        city_id: city_id
      },
      success: function(data) {
        if(city_id == null)
        {
          $(".city").html(data);
        }
        else
        {
          $("#e_city").html(data);
        }
      },
    });
  }
  function changePassword(id)
{
  $('#changePasswordModal').modal('toggle'); 
  $('#distributor_id').val(id); 
};
$("#change-password-form").submit(function(e){
  e.preventDefault();
  enableButton();
  if($('#new_password').val() !== $('#confirm_password').val()){
    $('#change-password-form')[0].reset();
    toastr.error("New Password and confirm password does not match");
    return false;
  }
  $.ajax({
      url: "<?php echo base_url('distributor/changePassword'); ?>",
      method: "POST",
      data: {
          id:$('#distributor_id').val(),
          password:$('#new_password').val()
      },
      success:function(res){
        enableButton();
        $('#changePasswordModal').modal('toggle'); 
        $('#change-password-form')[0].reset();
        $('#tb').html(res);
        toastr.success("Password Changed Successfully");
      }
  });
});
</script>