<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Transaction extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
		$this->load->library('upload');

		
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Transaction';
        $data['staffs'] = $this->model->getResultData('staff',['is_suspended'=>0]);
        $page = 'transaction/index';
        $this->header_and_footer($page, $data);
    }
	
	
	public function addTransaction()
	{
		if($_POST['staff_id'])
		{
			$array = array(
				'staff_id' => $_POST['staff_id'],
				'month_year' => $_POST['month_year'],
				'amount' => $_POST['amount'],
				'note' => $_POST['note'],
			);
			if($this->model->add('transaction',$array))
			{
				$lead_id = $this->db->insert_id();
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','transaction');
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
		}
	}
	public function viewTransaction()
	{
		$where = [];
        if(isset($_POST['staff_id']) && $_POST['staff_id']!==''){
            $where = ['staff_id'=>$_POST['staff_id']];
        }
		if($this->session->userdata('usertype') == 'staff'){
            $where = ['staff_id'=>$this->session->userdata('id')];
        }
		$data['list'] = $this->model->getResultData('transaction',$where,null,'id','DESC');
		$this->load->view('transaction/tb',$data);
	}
	public function editTransaction()
	{
		$data = $this->model->getRowData('transaction',['id'=>$_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'staff_id' => $data['staff_id'],
			'month_year' => $data['month_year'],
			'amount' => $data['amount'],
			'note' => $data['note'],
		);
		echo json_encode($response);
	}
	public function updateTransaction()
	{
		if(isset($_POST['id']))
		{
			$array = array(
				'staff_id' => $_POST['staff_id'],
				'month_year' => $_POST['month_year'],
				'amount' => $_POST['amount'],
				'note' => $_POST['note'],
			);
			if($this->model->edit('transaction',$array,['id'=>$_POST['id']]))
			{
				$lead_id = $_POST['id'];
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','transaction detail');
				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
		}
	}
	
}
