<?php
defined('BASEPATH') OR exit('No direct script access allowed');
// Import the TCPDF library
require_once(APPPATH .'TCPDF-main/tcpdf.php');
require FCPATH.'mpdf_vendor/autoload.php';
class Quotation extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Quatation';	
		$data['companys'] = $this->model->getResultData('company',['is_disable'=>0]);	
		$data['dealers'] = $this->model->getResultData('distributor',['is_suspended'=>0]);	
		$data['products'] = $this->model->getResultData('product',['is_disable'=>0]);	
        $page = 'quotation/index';
        $this->header_and_footer($page, $data);
    }

	public function calculate_total_amount()
    {
        $mrp = (float)$this->input->post('mrp');
        $discount = (int)$this->input->post('discount');
        $quantity = (float)$this->input->post('qty');

        // Ensure that the values are not empty
        if (!empty($mrp) && isset($quantity)) {

            // If discount is not set, set it to 0
            $discount = isset($discount) ? $discount : 0;

            // If quantity is not set, set it to 1
            $quantity = isset($quantity) ? $quantity : 1;

            // Calculate total amount
            $amount = ($quantity * $mrp * (100 - $discount) / 100);

            // Return the total amount to the view
            echo json_encode(['amount' => $amount]);
        } else {
            // Handle the case when one or more values are empty
            // If quantity is not set, set it to 1
            $quantity = isset($quantity) ? $quantity : 1;

            // If discount is not set, set it to 0
            $discount = isset($discount) ? $discount : 0;

            // If both quantity and discount are blank, return mrp
            $amount = isset($quantity) && isset($discount) ? ($quantity * $mrp * (100 - $discount) / 100) : $mrp;

            echo json_encode(['amount' => round($amount,2)]);
        }
    }

    public function addQuotation()
    {
        if (isset($_POST['dealer_id'])) {
            if ($this->model->countData('quotation', []) > 0) {
                $latestQuotation = $this->model->getRowData('quotation', [], null, 'id', 'DESC');
                $latestNumber = $latestQuotation ? intval(substr($latestQuotation['quotation_id'], 4)) + 1 : 1;
            } else {
                $latestNumber = 1;
            }

            $number = sprintf('%03d', $latestNumber);
            $quotation_id = '2024' . $number;

            $dealer_id = $_POST['dealer_id'];
            $company_id = $_POST['company_id'];
            $product_ids = $_POST['product_id'];
            $mrps = $_POST['mrp'];
            $qtys = $_POST['qty'];
            $tdate = $_POST['tdate'];
            $sizes = $_POST['size'];
            // $gsts = $_POST['gst'];
            $discounts = $_POST['discount'];
            $amounts = $_POST['amount'];

            $totalAmount = 0; // Initialize total amount for the billing

            $success = true; // Variable to track if all products were added successfully
            $order_data = [
                'quotation_id' => $quotation_id,
                'dealer_id' => $dealer_id,
                'company_id' => $company_id,
                'tdate' => $tdate,
            ];
            $this->model->add('quotation', $order_data);
            $quotation_insert_id = $this->db->insert_id();
            for ($i = 0; $i < count($product_ids); $i++) {
                $product_id = $product_ids[$i];
                $mrp = $mrps[$i];
                $qty = $qtys[$i];
                $size = $sizes[$i];
                // $gst = $gsts[$i];
                $discount = $discounts[$i];
                $amount = $amounts[$i];

                $order_items_data = [
                    'quotation_id' => $quotation_insert_id,
                    'product_id' => $product_id,
                    'mrp' => $mrp,
                    'qty' => $qty,
                    'size' => $size,
                    // 'gst' => $gst,
                    'discount' => $discount,
                    'amount' => $amount,
                ];
                $this->model->add('quotation_products', $order_items_data);
                
            }
                $lead_id = $this->db->insert_id();
                $this->createLog($this->session->userdata('id'), $this->session->userdata('usertype'), $lead_id, 'add', 'quotation detail');
                echo json_encode(['return' => true, 'msg' => 'Added Successfully']);
        }
    }


	public function viewQuotation()
    {
		$data['list'] = $this->model->getResultData('quotation',['dealer_id!='=>'']);
// 		echo "<pre>";print_r($data['list']);die();
		$this->load->view('quotation/tb',$data);
    }
// 	public function editQuotation()
//     {
//         $response=array();
// 		$data = $this->model->getRowData('quotation',['id' => $_POST['id']]);
// 		$data2 = $this->model->getRowData('quotation_products',['quotation_id' => $_POST['id']]);
// 		$mrp = $this->model->getRowData('product',['id' => $data2['product_id']]);
// 		$response = array(
// 			'id' => $_POST['id'],
// 			'customer_id' => $data['customer_id'],
// 			'company_id' => $data['company_id'],
// 			'tdate' => $data['tdate'],
// 			'size' => $data['size'],
// 			'product_id' => $data2['product_id'],
// 			'discount' => $data2['discount'],
// 			'qty' => $data2['qty'],
// 			'amount' => $data2['amount'],
// 			'mrp' => $mrp['mrp'],
// 		);
// 		echo json_encode($response);
//     }
    public function editQuotation()
    {
        $response=array();
		$data['quotation'] = $this->model->getRowData('quotation',['id' => $_POST['id']]);
		$data['quotation_products'] = $this->model->getResultData('quotation_products',['quotation_id' => $_POST['id']]);
		$data['companys'] = $this->model->getResultData('company',['is_disable'=>0]);	
		$data['customers'] = $this->model->getResultData('customer',['is_suspended'=>0]);	
		$data['products'] = $this->model->getResultData('product',['is_disable'=>0]);	
	    $this->load->view('quotation/edit',$data);
    }
// 	public function updateQuotation()
//     {
//         if(isset($_POST['id']))
//         {
//             $customer_id = $_POST['customer_id'];
//             $company_id = $_POST['company_id'];
//             $product_ids = $_POST['product_id'];
//             $qtys = $_POST['qty'];
//             $tdate = $_POST['tdate'];
//             $size = $_POST['size'];
//             $discounts = $_POST['discount'];
//             $amounts = $_POST['amount'];

//             $totalAmount = 0; // Initialize total amount for the billing

//             $success = true; // Variable to track if all products were added/edited successfully

//             $order_data = [
//                 'customer_id' => $customer_id,
//                 'company_id' => $company_id,
//                 'tdate' => $tdate,
//                 'size' => $size,
//             ];

//             // Update the main quotation record
//             if (!$this->model->edit('quotation', $order_data, ['id' => $_POST['id']])) {
//                 $success = false; // Set success to false if main quotation update fails
//             }

//             // Loop through each product
//             for ($i = 0; $i < count($product_ids); $i++) {
//                 $product_id = $product_ids[$i];
//                 $qty = $qtys[$i];
//                 $discount = $discounts[$i];
//                 $amount = $amounts[$i];

//                 $order_items_data = [
//                     'product_id' => $product_id,
//                     'qty' => $qty,
//                     'discount' => $discount,
//                     'amount' => $amount,
//                 ];

//                 // Check if the product already exists for this quotation
//                 $existingProduct = $this->model->getSingle('quotation_products', ['quotation_id' => $_POST['id'], 'product_id' => $product_id]);

//                 if ($existingProduct) {
//                     // If the product exists, update its details
//                     if (!$this->model->edit('quotation_products', $order_items_data, ['id' => $existingProduct['id']])) {
//                         $success = false; // Set success to false if product update fails
//                     }
//                 } else {
//                     // If the product doesn't exist, add it
//                     $order_items_data['quotation_id'] = $_POST['id']; // Include the quotation ID
//                     if (!$this->model->add('quotation_products', $order_items_data)) {
//                         $success = false; // Set success to false if product addition fails
//                     }
//                 }
//             }

//             if ($success) {
//                 // Success message or further processing
//                 $lead_id = $this->db->insert_id();
//                 $this->createLog($this->session->userdata('id'), $this->session->userdata('usertype'), $lead_id, 'edit', 'quotation detail');
//                 echo json_encode(['return' => true, 'msg' => 'Update Successfully']);
//             } else {
//                 // Error handling
//                 echo json_encode(['return' => false, 'msg' => 'Update Failed']);
//             }
//         }
//     }
    public function updateQuotation()
    {
        if (isset($_POST['dealer_id'])) {
            if ($this->model->countData('quotation', []) > 0) {
                $latestQuotation = $this->model->getRowData('quotation', [], null, 'id', 'DESC');
                $latestNumber = $latestQuotation ? intval(substr($latestQuotation['quotation_id'], 4)) + 1 : 1;
            } else {
                $latestNumber = 1;
            }

            $number = sprintf('%03d', $latestNumber);
            $quotation_id = '2024' . $number;

            $dealer_id = $_POST['dealer_id'];
            $company_id = $_POST['company_id'];
            $product_ids = $_POST['product_id'];
            $qp_ids = $_POST['qp_id'];
            $qtys = $_POST['qty'];
            $tdate = $_POST['tdate'];
            $sizes = $_POST['size'];
            $mrps = $_POST['mrp'];
            // $gsts = $_POST['gst'];
            $discounts = $_POST['discount'];
            $amounts = $_POST['amount'];

            $totalAmount = 0; // Initialize total amount for the billing

            $success = true; // Variable to track if all products were added successfully
            $order_data = [
                'dealer_id' => $dealer_id,
                'company_id' => $company_id,
                'tdate' => $tdate,
            ];
            if (!$this->model->edit('quotation', $order_data,['id'=>$_POST['id']])) {
                
                $success = false; // Set success to false if any product fails to be added
            }
            for ($i = 0; $i < count($product_ids); $i++) {
                $product_id = $product_ids[$i];
                $qty = $qtys[$i];
                $size = $sizes[$i];
                $mrp = $mrps[$i];
                // $gst = $gsts[$i];
                $discount = $discounts[$i];
                $amount = $amounts[$i];
                $qp_id = $qp_ids[$i];
                
                if($qp_id){
                    // $qp_data = $this->model->getRowData('quotation_products',['id'=>$qp_id]);
                    $order_items_data_edit = [
                        'product_id' => $product_id,
                        'qty' => $qty,
                        'size' => $size,
                        'mrp' => $mrp,
                        // 'gst' => $gst,
                        'discount' => $discount,
                        'amount' => $amount,
                    ];
                    if (!$this->model->edit('quotation_products', $order_items_data_edit,['id'=>$qp_id])) {
                        
                        $success = false; // Set success to false if any product fails to be added
                    }
                }else{
                    $order_items_data_add = [
                        'quotation_id' => $_POST['id'],
                        'product_id' => $product_id,
                        'qty' => $qty,
                        'size' => $size,
                        'mrp' => $mrp,
                        // 'gst' => $gst,
                        'discount' => $discount,
                        'amount' => $amount,
                    ];
                    if (!$this->model->add('quotation_products', $order_items_data_add)) {
                        
                        $success = false; // Set success to false if any product fails to be added
                    }
                }
                
                

                
            }

            if ($success) {
                $lead_id = $this->db->insert_id();
                $this->createLog($this->session->userdata('id'), $this->session->userdata('usertype'), $lead_id, 'add', 'quotation detail');
                echo json_encode(['return' => true, 'msg' => 'Added Successfully']);
            }
        }
    }

    public function deleteQuotation()
    {
        if ($this->model->deleteData('quotation',['id' => $_POST['id']]) && $this->model->deleteData('quotation_products',['quotation_id' => $_POST['id']]) ){
            $this->viewQuotation();
        } 
    }
    public function deleteProduct()
    {
        $productId = $_POST['id'];
        if ($this->model->deleteData('quotation_products', ['id' => $productId])) {
            $this->viewQuotation();
        }
    }

        public function updateOrderStatus()
        {
            if (isset($_POST['id'], $_POST['status'])) {
                // Update the billing table
                $billingArray = array(
                    'status' => $_POST['status'],
                );

                if ($this->model->edit('billing', $billingArray, ['id' => $_POST['id']])) {
                    // Update the ordered table
                    $desiredStatus = $_POST['status'];
                    if ($desiredStatus !== 'Cancelled') {
                        $this->model->edit('ordered', ['status' => $desiredStatus], ['billing_id' => $_POST['id'], 'status !=' => 'Cancelled']);
                    }
                    // Add to order_status_master table
                    $this->model->add('order_status_master', ['billing_id' => $_POST['id'], 'order_status' => $_POST['status']]);

                    // Logging
                    $lead_id = $_POST['id'];
                    $this->createLog($this->session->userdata('id'), $this->session->userdata('usertype'), $lead_id, 'edit', 'order status');

                    echo json_encode(['return' => true, 'msg' => 'Updated Successfully']);
                }
            }
        }


	

	public function generate_quotation_pdf() {

        $id = $this->uri->segment(2);
        $html = $this->load->view('quotation/pdf','',true);
            $mpdf = new \Mpdf\Mpdf([
                'format'=>'A4',
                'margin_top'=>0,
                'margin_right'=>0,
                'margin_left'=>0,
                'margin_bottom'=>0,
            ]);
            $mpdf->WriteHTML($html);
            // $mpdf->Output();
            $mpdf->Output('quotation_invoice_'.$id.'.pdf', 'D');
        
            // $this->load->view('receipt_pdf');
    }
	public function view_quotation_pdf() {
        // $data['id'] = $this->uri->segment(2);
        // $html = $this->load->view('quotation/pdf',$data);
        $id = $this->uri->segment(2);
        $html = $this->load->view('quotation/pdf','',true);
            $mpdf = new \Mpdf\Mpdf([
                'format'=>'A4',
                'margin_top'=>0,
                'margin_right'=>0,
                'margin_left'=>0,
                'margin_bottom'=>0,
            ]);
            $mpdf->WriteHTML($html);
            $mpdf->Output();
    }
    function print()
        {
            $html = $this->load->view('receipt_pdf','',true);
            $mpdf = new \Mpdf\Mpdf([
                'format'=>'A4',
                'margin_top'=>0,
                'margin_right'=>0,
                'margin_left'=>0,
                'margin_bottom'=>0,
            ]);
            $mpdf->WriteHTML($html);
            // $mpdf->Output();
            $mpdf->Output('MyPDF.pdf', 'D');
        }	
	
}
