<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Order extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
		$this->load->library('upload');

		
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Order';
        $data['categories'] = $this->model->getResultData('product_category',['is_disable'=>0]);
        $data['channel_partners'] = $this->model->getResultData('channel_partner',['is_suspended'=>0]);
        $page = 'order/index';
        $this->header_and_footer($page, $data);
    }
	public function addOrder()
    {
			if($_POST['order_value'])
			{
				if(isset($_POST['channel_partner_id'])){
					$channel_partner_id = $_POST['channel_partner_id'];
				}else{
					$channel_partner_id = $this->session->userdata('id');
				}
				if($this->model->countData('orders',[]) > 0){
					$number = $this->model->getRowData('orders',[],null,'id','DESC')['id'] + 1;
					$number = sprintf('%03d',$number);
				}else{
					$number = sprintf('%03d',1);
				}
				$order_id = 'CP'.$number;
				$array = array(
					'order_id' => $order_id,
					'channel_partner_id' => $channel_partner_id,
					'category_id' => $_POST['category_id'],
					'product_id' => $_POST['product_id'],
					'order_value' => $_POST['order_value'],
					'commision' => $_POST['commision'],
					'description' => $_POST['description'],
					'client_name' => $_POST['client_name'],
					'client_email' => $_POST['client_email'],
					'client_mobile' => $_POST['client_mobile'],
				);
				if($this->model->add('orders',$array))
				{
					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
				
			}
				
        
	}
	
	
	public function viewOrder()
    {
		$where = [];
        if(isset($_POST['channel_partner_id']) && $_POST['channel_partner_id']!==''){
            $where = ['channel_partner_id'=>$_POST['channel_partner_id']];
        }
		if($this->session->userdata('usertype') == 'channel_partner'){
            $where = ['channel_partner_id'=>$this->session->userdata('id')];
        }
		$data['list'] = $this->order_model->getOrderResultData($where);
		$this->load->view('order/tb',$data);
    }
	public function editOrder()
    {
        $response=array();
		$data = $this->model->getRowData('orders',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'channel_partner_id' => $data['channel_partner_id'],
			'category_id' => $data['category_id'],
			'product_id' => $data['product_id'],
			'order_value' => $data['order_value'],
			'commision' => $data['commision'],
			'description' => $data['description'],
			'client_name' => $data['client_name'],
			'client_email' => $data['client_email'],
			'client_mobile' => $data['client_mobile'],
			
		);
		echo json_encode($response);
    }        
	public function updateOrder()
    {
			if(isset($_POST['id']))
			{
				if($_POST['channel_partner_id']){
					$channel_partner_id = $_POST['channel_partner_id'];
				}else{
					$channel_partner_id = $this->session->userdata('id');
				}
				$array = array(
					'channel_partner_id' => $channel_partner_id,
					'category_id' => $_POST['category_id'],
					'product_id' => $_POST['product_id'],
					'order_value' => $_POST['order_value'],
					'commision' => $_POST['commision'],
					'description' => $_POST['description'],
					'client_name' => $_POST['client_name'],
					'client_email' => $_POST['client_email'],
					'client_mobile' => $_POST['client_mobile'],
				);
				if($this->model->edit('orders',$array,['id'=>$_POST['id']]))
				{
					$lead_id = $_POST['id'];
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
			else
			{
				echo json_encode(['return'=>false,'msg'=>'`id` is required']);
			}		
    }
  
	public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Order Detail';
		$data['data'] = $this->order_model->getOrderRowData($id);
        $page = 'order/detail';
        $this->header_and_footer($page, $data);
    }
	public function editOrderStatus()
    {
		$data = $this->model->getRowData('orders',['id'=>$_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'status' => $data['status'],
		);
		echo json_encode($response);
    }
	public function updateOrderStatus()
    {
        if(isset($_POST['id']))
		{
			$array = array(
				'status' => $_POST['status'],
			);
			if($this->model->edit('orders',$array,['id'=>$_POST['id']]))
			{
				$lead_id = $_POST['id'];
				// $this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','order status');
				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
		}
    }

		//payment status
		public function updatePaymentStatus()
		{
			if(isset($_POST['id']))
			{
				$array = array(
					'payment_status' => $_POST['payment_status'],
				);
				if($this->model->edit('orders',$array,['id'=>$_POST['id']]))
				{
					$lead_id = $_POST['id'];
					// $this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','order status');
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
		}
		public function editPaymentStatus()
		{
			$data = $this->model->getRowData('orders',['id'=>$_POST['id']]);
			$response = array(
				'id' => $_POST['id'],
				'payment_status' => $data['payment_status'],
			);
			echo json_encode($response);
		}

		
}
