<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Design extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
		$this->load->library('upload');

		
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Design';
        $data['categories'] = $this->model->getResultData('product_category',['is_disable'=>0]);
        $data['products'] = $this->model->getResultData('product',['is_disable'=>0]);
        $page = 'design/index';
        $this->header_and_footer($page, $data);
    }
	public function addDesign()
    {
			if($_POST['name'])
			{
				$array = array(
					'name' => $_POST['name'],
					'category_id' => $_POST['category_id'],
					'product_id' => $_POST['product_id'],
					'mrp' => $_POST['mrp'],
					'description' => $_POST['description'],
				);
				if($this->design_model->addDesign($array))
				{
					$lead_id = $this->db->insert_id();
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','Design detail');

					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
				
			}
				
        
	}
		public function designImage()
    {
		$data['list'] = $this->design_model->designImage($_POST['design_id']);
    }
	public function deleteDesignImage()
    {
        if(isset($_POST['image_id']))
		{
			if($this->design_model->deleteDesignImage($_POST['image_id']))
			{
				$lead_id = $_POST['image_id'];
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','design image');
				echo json_encode(['return'=>true,'msg'=>'Image Deleted Successfully']);
			}
		}
    }
	public function addDesignImage()
    {
        if($_POST['design_id'])
		{
			if($this->design_model->addDesignImage($_POST['design_id']))
			{
				$lead_id = $this->db->insert_id();
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','design image');
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
		}
    }
	public function makeDesignCoverImage()
    {
        if(isset($_POST['image_id']))
		{
			if($this->model->edit('design_image',['is_cover'=>0],['design_id'=>$_POST['design_id']]))
			{
				$this->model->edit('design_image',['is_cover'=>1],['id'=>$_POST['image_id']]);
				
				echo json_encode(['return'=>true,'msg'=>'Cover Updated Successfully']);
			}
		}
    }	
	
	public function viewDesign()
    {
		$data['list'] = $this->model->getResultData('design',[]);
		$this->load->view('design/tb',$data);
    }
	public function editDesign()
    {
        $response=array();
		$data = $this->model->getRowData('design',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'name' => $data['name'],
			'product_id' => $data['product_id'],
			'category_id' => $data['category_id'],
			'mrp' => $data['mrp'],
			'description' => $data['description']
			
		);
		echo json_encode($response);
    }        
	public function updateDesign()
    {
			if(isset($_POST['id']))
			{
				$array = array(
					'name' =>$_POST['name'],
					'product_id' => $_POST['product_id'],
					'category_id' => $_POST['category_id'],
					'mrp' => $_POST['mrp'],
					'description' => $_POST['description'],
				);
				if($this->design_model->updateDesign($array,$_POST['id']))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','Design detail');
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
			else
			{
				echo json_encode(['return'=>false,'msg'=>'`id` is required']);
			}
			
		
    }
  
   
	public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Design Detail';
		$data['data'] = $this->design_model->getDesignRowData($id);
        $page = 'design/detail';
        $this->header_and_footer($page, $data);
    }

	
}
