<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'Auth';
// $route['home'] = 'Website';
$route['subscribe/(:num)'] = 'Website';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

$route['admin'] = 'Auth';
$route['change-password'] = 'Auth/change_pass/';
$route['logout'] = 'Dashboard/logout';
// application/config/routes.php

$route['reset/{$token}'] = 'auth/reset_password';
$route['reset/(:any)'] = 'auth/reset_password/$1';
// application/config/routes.php
$route['auth/process_reset_password'] = 'auth/process_reset_password';
$route['email'] = 'auth/forgotPass';
$route['auth/send_reset_link'] = 'auth/send_reset_link';


//channel partner reset password from login page
$route['cp-reset/{$token}'] = 'channel_partner_auth/reset_password';
$route['cp-reset/(:any)'] = 'channel_partner_auth/reset_password/$1';
$route['cp-email'] = 'channel_partner_auth/forgotPass';


// Admin and staff logs
$route['logs'] = 'Admin/logs';

//Staff
$route['staff-login'] = 'Staff_auth';
$route['staff-change-password'] = 'Staff_auth/change_pass/';
$route['staff-detail/(:num)'] = 'Staff/detail';

//Manager
$route['manager'] = 'Manager';
$route['manager-detail/(:num)'] = 'Manager/detail';
$route['manager-login'] = 'Manager_auth';
$route['manager-change-password'] = 'Manager_auth/change_pass/';

//channel partner
$route['manage-channel-partner'] = 'Channel_partner';
$route['channel-partner-detail/(:num)'] = 'Channel_partner/detail';
$route['channel-partner-login'] = 'Channel_partner_auth';
$route['channel-partner-change-password'] = 'Channel_partner_auth/change_pass/';

//commision level
$route['manage-commision-level'] = 'Commision/commision_level';
$route['commision-detail/(:num)'] = 'Commision/detail';
$route['manage-commision'] = 'Commision/commision';
$route['commisions'] = 'Commision/commisions';

$route['cp-commisions'] = 'Commision/cp_commisions';

// payout management
$route['manage-payout'] = 'Payout';

//product
$route['product-category'] = 'Product/productCategory';
$route['product-detail/(:num)'] = 'Product/detail';
$route['product'] = 'Product';

//order
$route['manage-order'] = 'Order';
$route['order-detail/(:num)'] = 'Order/detail';