<?php


class Order_model extends CI_Model
{
    public function getOrderResultData()
	{
        $query = $this->db
        ->select('t1.*,t2.name as product_name,t3.fullname as customer_name,t4.name as category_name')
        ->from('orders t1')
        ->join('product t2', 't2.id = t1.product_id','left') 
        ->join('customer t3', 't3.id = t1.customer_id','left') 
        ->join('product_category t4', 't3.id = t1.category_id','left') 
        ->get();
		return $query->result_array();
	}

    public function getOrderRowData($id)
	{
        $query = $this->db
        ->select('t1.*,t2.name as product_name,t3.fullname as customer_name,t4.name as category_name')
        ->from('orders t1')
        ->join('product t2', 't2.id = t1.product_id','left') 
        ->join('customer t3', 't3.id = t1.customer_id','left') 
        ->join('product_category t4', 't3.id = t1.category_id','left') 
        ->where(['t1.id'=>$id])
        ->get();
		return $query->row_array();
	}
    public function orderImage($order_id)
	{
		$images = $this->db->get_where('order_image',['order_id'=>$order_id])->result_array();
        $data = '';
        $i=1;
        foreach($images as $image){
            $ext = substr($image['image'], strrpos($image['image'], '.') + 1);
            $data.= '<tr>';
            $data.= '<td>'.$i++.'</td>';
            
            if($ext == 'mp4' || $ext == 'mov'){
                $data.= '<td><iframe src="'.base_url('assets/uploads/'.$image['image']).'" height="80" width="100"></iframe></td>';
            }else{
                $data.= '<td><img src="'.base_url('assets/uploads/'.$image['image']).'" height="70"></td>';
            }

            $data.= '<td>';
            $data.= '<button class="btn btn-sm btn-danger" onclick="deleteOrderImage('.$image['id'].','.$order_id.')">Delete</button>';
            $data.='</td>';
            $data.= '</tr>';
        }
        echo $data;
	}
    public function addOrderImage($order_id)
	{
        $data = array();
        if (!empty($_FILES['order_image']['name'])) {
            $config['file_name'] = rand(10000, 10000000000);
            $config['upload_path'] = './assets/uploads/order';
            $config['allowed_types'] = 'jpg|jpeg|png|mp4|mov';
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
    
            //upload images
            $_FILES['order_images']['name'] = $_FILES['order_image']['name'];
            $_FILES['order_images']['type'] = $_FILES['order_image']['type'];
            $_FILES['order_images']['tmp_name'] = $_FILES['order_image']['tmp_name'];
            $_FILES['order_images']['size'] = $_FILES['order_image']['size'];
            $_FILES['order_images']['error'] = $_FILES['order_image']['error'];

            if ($this->upload->do_upload('order_images')) {
                $image_data = $this->upload->data();

                $config2 = array(
                    'image_library' => 'gd2', //get original image
                    'source_image' =>  './assets/uploads/order/'. $image_data['file_name'],
                    'width' => 540,
                    'height' => 600,
                    'maintain_ratio' => FALSE,
                    'new_image' =>  './assets/uploads/order/'. $image_data['file_name'],

                );
                $this->load->library('image_lib');
                $this->image_lib->initialize($config2);
                $this->image_lib->resize();
                $this->image_lib->clear();

                $fileName = "order/" . $image_data['file_name'];
                $data['image'] = $fileName;
                $data['order_id'] = $order_id;
            }
        } else {
            $data['image'] = '';
            $data['order_id'] = '';
        }
		return $this->db->insert('order_image', $data);
       
	}
    public function deleteOrderImage($id)
    {
        $image = $this->model->getRowData('order_image',['id'=>$id]);
        $order_image = ltrim($image['image'], '/');
        if(is_file(base_url('assets/uploads/'.$order_image)))
        {
            unlink(base_url('assets/uploads/'.$order_image));
        }
        return $this->db->delete('order_image',['id'=>$id]);
        
	}
}

?>