<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dealer extends CI_Controller {


    // Dealer Login API
    public function dealerLogin(){
        if(isset($_POST['email']) && $_POST['email'] !== '' && isset($_POST['password']) && $_POST['password'] !== '' )
        {
            $dealerData = $this->model->getRowData('distributor',['emailid'=>$_POST['email'],'password'=>md5($_POST['password'])]);
            if($dealerData['is_suspended'] == 1){
                echo json_encode(['return'=>false,'msg'=>'You are Suspended!']);
            }          
            else if($dealerData){
                echo json_encode(['return'=>true,'msg'=>'Logged in Successfully','dealer_id'=>$dealerData['id'],'api_key'=>get_setting()['api_key']]);
            }else{
                echo json_encode(['return'=>false,'msg'=>'Invalid Email or Password!!']);
            }
        }
        else
        {
            echo json_encode(['return'=>false,'msg'=>'`email`,`password` is required']);
        }
    }
    // Dealer details apis
    public function dealerDetails(){
        if(isset($_REQUEST['api_key']) && $_REQUEST['api_key']!=='')
        {
            if($_REQUEST['api_key'] == get_setting()['api_key'])
            {
                $response = [];
                
                if(isset($_REQUEST['id']) && $_REQUEST['id'] !== '')
                {
                    $val = $this->api_model->getDealerRowData($_REQUEST['id']);
                   
                        $array = array(
                            'id' => $val['id'],
                            'dealerId' => $val['distributor_id'],
                            'fullname' => ucfirst($val['fullname']),
                            'email' => $val['emailid'],
                            'mobile' => $val['mobile'],
                            'country' => $val['country_name'],
                            'state' => $val['state_name'],
                            'city' => $val['city_name'],
                            'pincode' => $val['pincode'],
                            'gender' =>  $val['gender'],
                            'dob' => $val['dob'],
                            'address' => $val['address'],
                            

                        );
                        array_push($response,$array);
                    
                    echo json_encode(['return'=>true,'list'=>$response]);
                }else{
                    echo json_encode(['return'=>false,'msg'=>'`id` is required']);
                }
            }
            else
            {
                echo json_encode(['return'=>false,'msg'=>'Invalid Api key']);
            }
        }		
        else
        {
            echo json_encode(['return'=>false,'msg'=>'Api key is required']);
        }

    }
    public function addQuotation()
    {
        if(isset($_POST['api_key']) && $_POST['api_key']!=='')
	    {
    	    if($_POST['api_key'] == get_setting()['api_key'])
    	    {
				if(isset($_POST['customer_id']) && $_POST['customer_id']!=='')
	    		{	
                    if ($this->model->countData('quotation', []) > 0) {
                        $latestQuotation = $this->model->getRowData('quotation', [], null, 'id', 'DESC');
                        $latestNumber = $latestQuotation ? intval(substr($latestQuotation['quotation_id'], 4)) + 1 : 1;
                    } else {
                        $latestNumber = 1;
                    }
        
                    $number = sprintf('%03d', $latestNumber);
                    $quotation_id = '2024' . $number;

                    $array = [
                        'quotation_id' => $quotation_id,
                        'customer_id' => $_POST['customer_id'],
                        'company_id' => $_POST['company_id'],
                        'date' => $_POST['tdate'],
                    ];
                    
                    if($this->model->add('quotation', $array))
                    {
                        echo json_encode(['return'=>true,'msg'=>'Added successfully..']);
                    }
				}
				else
				{
					echo json_encode(['return'=>false,'msg'=>'customer_id is required']);
				}
    	    }
    	    else
    		{
                echo json_encode(['return'=>false,'msg'=>'Invalid Api key']);
    		}
	    }
	    else
		{
            echo json_encode(['return'=>false,'msg'=>'`api_key` is required']);
		}
    }
    public function addQuotationProducts()
    {
        if(isset($_POST['api_key']) && $_POST['api_key']!=='')
	    {
    	    if($_POST['api_key'] == get_setting()['api_key'])
    	    {
				if(isset($_POST['quotation_id']) && $_POST['quotation_id']!=='')
	    		{	
                    
                    $array = [
                        'quotation_id' => $_POST['quotation_id'],
                        'product_id' => $_POST['product_id'],
                        'mrp' => $_POST['mrp'],
                        'qty' => $_POST['qty'],
                        'size' => $_POST['size'],
                        'discount' => $_POST['discount'],
                        'amount' => $_POST['amount'],
                    ];
                                        
                    if($this->model->add('quotation_products', $array))
                    {
                        echo json_encode(['return'=>true,'msg'=>'Added successfully..']);
                    }
				}
				else
				{
					echo json_encode(['return'=>false,'msg'=>'customer_id is required']);
				}
    	    }
    	    else
    		{
                echo json_encode(['return'=>false,'msg'=>'Invalid Api key']);
    		}
	    }
	    else
		{
            echo json_encode(['return'=>false,'msg'=>'`api_key` is required']);
		}
    }
   
    public function quotationDetails(){
        if(isset($_REQUEST['api_key']) && $_REQUEST['api_key']!=='')
        {
            if($_REQUEST['api_key'] == get_setting()['api_key'])
            {
                if(isset($_REQUEST['quotation_id']) && $_REQUEST['quotation_id'] !== '')
                {
                    $val = $this->api_model->getQuotationRowData($_REQUEST['quotation_id']);
                   
                        $response = array(
                            'id' => $val['id'],
                            'quotationId' => $val['quotation_id'],
                            'customer_id' => $val['customer_id'],
                            'customer_name' => $val['customer_name'],
                            'company_id' => $val['company_id'],
                            'company_name' => $val['company_name'],
                            'date' => $val['date'],
                        );

                        //quotation products
                        $list = $this->api_model->getQuotationProductsData($_REQUEST['quotation_id']);
                        foreach($list as $data){
                            $quotation_products_array = array(
                                'id' => $data['id'],
                                'product_id' => $data['product_id'],
                                'product_name' => $data['product_name'],
                                'mrp' => $data['mrp'],
                                'qty' => $data['qty'],
                                'size' => $data['size'],
                                'discount' => $data['discount'],
                                'amount' => $data['amount'],
                            );
                            array_push($response,$array);
                        }
                        
                    
                    echo json_encode(['return'=>true,'list'=>$response]);
                }else{
                    echo json_encode(['return'=>false,'msg'=>'`quotation_id` is required']);
                }
            }
            else
            {
                echo json_encode(['return'=>false,'msg'=>'Invalid Api key']);
            }
        }		
        else
        {
            echo json_encode(['return'=>false,'msg'=>'Api key is required']);
        }

    }


    
}
