<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Staff extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Staff';
		//generate employee id
		if($this->model->countData('staff',[]) > 0){
			$number = $this->model->getRowData('staff',[],null,'id','DESC')['id'] + 1;
			$number = sprintf('%03d',$number);
			$data['employeeId'] = 'CEMP'.$number;
		}else{
			$data['employeeId'] = 'CEMP'.sprintf('%03d',1);
		}
		$data['departments'] = $this->model->getResultData('department',['is_disable'=>0]);
		$data['countries'] = $this->model->getResultData('countries',[]);
        $page = 'staff/index';
        $this->header_and_footer($page, $data);
    }
	public function addStaff()
    {
		$countEmail = $this->model->countData('staff',['emailid'=>$_POST['emailid']]);
		if($countEmail > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		}
		else
		{
			if($_POST['fullname'])
			{
				$array = array(
					'department_id' => $_POST['department_id'],
					'fullname' => ucfirst($_POST['fullname']),
					'type' => $_POST['type'],
					'emailid' => $_POST['emailid'],
					'password' =>md5($_POST['password']),
					'mobile' =>  $_POST['mobile'],
				// 	'country' => $_POST['country'],
				// 	'state' => $_POST['state'],
				// 	'city' => $_POST['city'],
					'employee_id' => $_POST['employee_id'],
					// 'pincode' => $_POST['pincode'],
					// 'gender' => $_POST['gender'],
					// 'dob' => $_POST['dob'],
				// 	'address' => $_POST['address'],
				);
				if($this->model->add('staff',$array))
				{
					$lead_id = $this->db->insert_id();
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','staff detail');

					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
				
			}
		}
    }
	public function viewStaff()
    {
		$data['list'] = $this->model->getResultData('staff',[]);
		$this->load->view('staff/tb',$data);
    }
	public function editStaff()
    {
        $response=array();
		$data = $this->model->getRowData('staff',['id' => $_POST['id']]);
		if($data['mobile'] !== '')
		{
			$mob = explode(' ',$data['mobile']);
			$ccode = $mob[0];
			$contact = $mob[1];
		}else{
			$mob = '';
			$ccode = '';
			$contact = '';
		}
		$response = array(
			'id' => $_POST['id'],
			'type' => $data['type'],
			'department_id' => $data['department_id'],
			'fullname' => $data['fullname'],
			'email' => $data['emailid'],
			'mobile' => $contact,
			'ccode' => str_replace("+","",$ccode),
			'password' => $data['password'],
// 			'country' => $data['country'],
// 			'state' => $data['state'],
// 			'city' => $data['city'],
			'employee_id' => $data['employee_id'],
// 			'pincode' => $data['pincode'],
// 			'gender' => $data['gender'],
// 			'dob' => $data['dob'],
// 			'address' => $data['address'],
		);
		echo json_encode($response);
    }
	public function updateStaff()
    {
		$countEmail = $this->model->countData('staff',['emailid'=>$_POST['emailid'],'id!='=>$_POST['id']]);
		if($countEmail > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		}
		else
		{
			if(isset($_POST['id']))
			{
				$array = array(
					'department_id' => $_POST['department_id'],
					'fullname' => ucfirst($_POST['fullname']),
					'type' => $_POST['type'],
					'emailid' => $_POST['emailid'],
					'mobile' =>  $_POST['mobile'],
				// 	'country' => $_POST['country'],
				// 	'state' => $_POST['state'],
				// 	'city' => $_POST['city'],
					'employee_id' => $_POST['employee_id'],
					// 'pincode' => $_POST['pincode'],
					// 'gender' => $_POST['gender'],
					// 'dob' => $_POST['dob'],
				// 	'address' => $_POST['address'],
				);
				if($this->model->edit('staff',$array,['id' => $_POST['id']]))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','staff detail');
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
			else
			{
				echo json_encode(['return'=>false,'msg'=>'`id` is required']);
			}
		}
    }
  
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Staff Detail';
		$data['data'] = $this->staff_model->getStaffRowData($id);
        $page = 'staff/detail';
        $this->header_and_footer($page, $data);
    }
    

	//Documents
	public function documents()
    {
        $data['title'] = 'Staff documents';
		$data['staffs'] = $this->model->getResultData('staff',['is_suspended'=>0]);
        $page = 'staff_docs/index';
        $this->header_and_footer($page, $data);
    }
	public function addDocument()
    {
        if(isset($_POST['staff_id']))
		{
			$countStaff = $this->model->countData('staff_docs',['staff_id'=>$_POST['staff_id']]);
			if($countStaff > 0 )
			{
				echo json_encode(['return'=>false,'msg'=>'Staff already exist']);
			}
			else
			{
				$array = array(
					'staff_id' => $_POST['staff_id'],
					'bank_name' => $_POST['bank_name'],
					'account_name' => $_POST['account_name'],
					'account_no' => $_POST['account_no'],
					'account_ifsc' => $_POST['account_ifsc'],
					'branch_name' => $_POST['branch_name'],
				);
				if($this->staff_model->addDocument($array))
				{
					$lead_id = $this->db->insert_id();
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','staff document');

					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
			}
			
		}
    }
	public function viewDocument()
    {
		$data['staffs'] = $this->model->getResultData('staff',['is_suspended'=>0]);
		$data['list'] = $this->staff_model->getDocumentResultData();
		$this->load->view('staff_docs/tb',$data);
    }
	public function editDocument()
    {
		$response=array();
		$data = $this->model->getRowData('staff_docs',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'staff_id' => $data['staff_id'],
			'document1' => base_url('assets/uploads/'.$data['document1'].''),
			'document2' => base_url('assets/uploads/'.$data['document2'].''),
			'document3' => base_url('assets/uploads/'.$data['document3'].''),
			'document4' => base_url('assets/uploads/'.$data['document4'].''),
			'document5' => base_url('assets/uploads/'.$data['document5'].''),
			'bank_name' => $data['bank_name'],
			'account_name' => $data['account_name'],
			'account_no' => $data['account_no'],
			'account_ifsc' => $data['account_ifsc'],
			'branch_name' => $data['branch_name'],
		);
		echo json_encode($response);
    }
	public function updateDocument()
    {
        if(isset($_POST['staff_id']))
		{
			$countStaff = $this->model->countData('staff_docs',['staff_id'=>$_POST['staff_id'],'id!='=>$_POST['id']]);
			if($countStaff > 0 )
			{
				echo json_encode(['return'=>false,'msg'=>'Staff already exist']);
			}
			else
			{
				$array = array(
					'staff_id' => $_POST['staff_id'],
					'bank_name' => $_POST['bank_name'],
					'account_name' => $_POST['account_name'],
					'account_no' => $_POST['account_no'],
					'account_ifsc' => $_POST['account_ifsc'],
					'branch_name' => $_POST['branch_name'],
				);
				if($this->staff_model->updateDocument($array,$_POST['id']))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','staff document');

					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
			
		}
    }
	public function changePassword()
    {
        if($_POST['id'])
		{
			if($this->model->edit('staff',['password'=>md5($_POST['password'])],['id' => $_POST['id']]))
			{
				$this->viewStaff();
			}
			
		}
    }

	public function attendance()
    {
        $data['title'] = 'Attendance';
		$data['staffs'] = $this->model->getResultData('staff',['is_suspended'=>0]);
		
        $page = 'staff_attendance/index';
        $this->header_and_footer($page, $data);
    }
	public function viewAttendance()
    {
		$date = date('Y-m-d');$month = null;$staff = null;
		if(isset($_POST['date']) && $_POST['date'] !== '')
		{
			$date = $_POST['date'];
		}
		if(isset($_POST['month']) && $_POST['month'] !== '')
		{
			$month = $_POST['month'];
		}
		if(isset($_POST['staff']) && $_POST['staff'] !== '')
		{
			$staff = $_POST['staff'];
		}
		$data['date'] = $date;
		$data['month'] = $month;
		$data['staff'] = $staff;
		$where = [];
		if($this->session->userdata('usertype') == 'staff'){
			$where = ['t1.staff_id'=>$this->session->userdata('id')];
		}
		$data['list'] = $this->staff_model->getAttendanceResultData($where,$date,$month,$staff);
		// echo $this->db->last_query();
		// die('A');
		$this->load->view('staff_attendance/tb',$data);
    }
    public function detailAttendance()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Attendance Detail';
		$data['data'] = $this->staff_model->getAttendanceRowData($id);
		// echo "<pre>";print_r($data['data']);exit();
        $page = 'staff_attendance/detail';
        $this->header_and_footer($page, $data);
    }
	//Attendance
	public function attendanceView(){
		$data = '';
		if($this->session->userdata('usertype') == 'staff'){
			$staff_id = $this->session->userdata('id');
			$getTodayData = $this->model->getRowData('staff_attendance',['staff_id'=>$staff_id,'punch_in_date'=>date("d-m-Y"),'punch_out_date'=>NULL]);
			if($getTodayData){
				$data='
				<div class="media-body">
				<p class="f-w-500 font-roboto">Punch in on '.date('d-m-Y',strtotime($getTodayData['punch_in_date'])).' at '.date('h:i a',strtotime($getTodayData['punch_in_time'])).'</p>
				</div>
				';
				
				$data.= '<a class="btn btn-secondary punchout-btn" onclick="punchOut()">Punch out</a>';
				
			}else{
				$data = '<a class="btn btn-primary punchin-btn" onclick="punchIn()">Punch In</a>';
			}
			echo $data;
		}
		

	}
	public function punchIn()
    {
		//upload image
		$img = $_POST['image'];
		$folderPath = "./assets/uploads/";
	
		$image_parts = explode(";base64,", $img);
		$image_type_aux = explode("image/", $image_parts[0]);
		$image_type = $image_type_aux[1];
	
		$image_base64 = base64_decode($image_parts[1]);
		$fileName = 'staff_attendance/'.uniqid() . '.png';
	
		$file = $folderPath . $fileName;
		file_put_contents($file, $image_base64);

        $array = array(
			'staff_id' => $this->session->userdata('id'),
			'punch_in_date' =>date('d-m-Y'),
			'punch_in_time' =>  date('h:i:s'),
			'punch_in_photo' =>  $fileName,
		);
		if($this->model->add('staff_attendance',$array))
		{
			$lead_id = $this->db->insert_id();
			$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','staff attendance punch in');
			
			echo json_encode(['return'=>true,'msg'=>'Punch In Successfully']);
		}
    }
	public function punchOut()
    {
		//upload image
		$img = $_POST['image'];
		$folderPath = "./assets/uploads/";
	
		$image_parts = explode(";base64,", $img);
		$image_type_aux = explode("image/", $image_parts[0]);
		$image_type = $image_type_aux[1];
	
		$image_base64 = base64_decode($image_parts[1]);
		$fileName = 'staff_attendance/'.uniqid() . '.png';
	
		$file = $folderPath . $fileName;
		file_put_contents($file, $image_base64);

        $array = array(
			'punch_out_date' =>date('d-m-Y'),
			'punch_out_time' =>  date('h:i:s'),
			'punch_out_photo' =>  $fileName,
		);

		if($this->model->edit('staff_attendance',$array,['staff_id' => $this->session->userdata('id'),'punch_out_date'=>NULL]))
		{
			$lead_id = $this->db->insert_id();
			$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','staff attendance punch out');
			
			echo json_encode(['return'=>true,'msg'=>'Punch Out Successfully']);
		}
    }

	public function filterMonthData()
    {
		$month = null;
		if(isset($_POST['month']) && $_POST['month'] !== '')
		{
			$month = $_POST['month'];
		}
		$data['month'] = $month;
		$where = [];
		if($this->session->userdata('usertype') == 'staff'){
			$where = ['t1.staff_id'=>$this->session->userdata('id')];
		}
		$list = $this->staff_model->getAttendanceResultData($where,null,$month);
		$month_array = array();
		foreach($list as $val){
			$m = date('d',strtotime($val['created']));
			if(!in_array($m,$month_array)){
				array_push($month_array,$m);
			}
			
		}
		// print_r($month_array);
		// exit();
		$content = '';
		$content.= '<table bgcolor="lightgrey" align="center" 
		cellspacing="21" cellpadding="21" class="mb-5">
		<tbody>
			<tr>';
				for($i=01;$i<=16;$i++){
					$class1='';
					if(in_array($i,$month_array)){
						$class1 = 'bg-success';
					}else if(!in_array($i,$month_array) && $i<date('d')  || $month < date('Y-m')){
						$class1 = 'bg-danger';
					}
					if($month > date('Y-m')){
						$class1 = '';
					}
	$content.= '<td class="'.$class1.'">'.$i.'</td>';
				}
	$content.='</tr>
			<tr>';
			for($i=17;$i<=31;$i++){
				$class2='';
				if(in_array($i,$month_array)){
					$class2 = 'bg-success';
				}else if(!in_array($i,$month_array) && $i<=date('d') || $month < date('Y-m')){
					$class2 = 'bg-danger';
				}
				if($month > date('Y-m')){
					$class2 = '';
				}
	$content.= 	'<td class="'.$class2.'">'.$i.'</td>';
			}
	$content.= 	'</tr>
		</tbody>
	</table>';
	echo $content;
    }
	
	
}
