<!DOCTYPE html>
<html lang="en">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Password</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #0000FF;
            margin: 0;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
        }

        form {
            background-color: #ffffff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            width: 350px;
            text-align: center;
        }

        h2 {
            color: red;
        }

        label {
            display: block;
            margin-top: 15px;
            font-weight: bold;
            color: #333;
        }

        input {
            width: 100%;
            padding: 12px;
            margin-top: 8px;
            margin-bottom: 20px;
            box-sizing: border-box;
            border: 1px solid #007bff;
            border-radius: 5px;
            outline: none;
        }

        input:focus {
            border-color: #0056b3;
        }

        button {
            background-color: #28a745;
            color: #fff;
            padding: 12px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            width: 100%;
        }

        button:hover {
            background-color: #218838;
        }

        .error {
            color: #dc3545;
            margin-top: 8px;
        }

        .logo {
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 20px;
            color: #007bff;
            text-decoration: none;
            font-size: 24px;
            font-weight: bold;
        }

        .logo img {
            height: 50px;
            margin-left: 10px;
        }
    </style>
</head>
<body>
    
    <form action="<?= base_url('channel_partner_auth/process_reset_password'); ?>" method="post" onsubmit="return validateForm()">
        <!-- <a class="logo" href=""> 
            <img class="img-fluid for-light" src="<?= base_url('assets/images/logo/quotation.jpg'); ?>" alt="looginpage">
        </a> -->

        <h2>Reset Your Admin Password</h2>
        <input type="hidden" name="token" value="<?= $token; ?>">
        
        <label for="new_password">New Password:</label>
        <input type="password" name="new_password" id="new_password" required>
        
        <label for="confirm_password">Confirm Password:</label>
        <input type="password" name="confirm_password" id="confirm_password" required>
        <div id="passwordError" class="error"></div>
        
        <button type="submit">Reset Password</button>
    </form>

    <script>
        function validateForm() {
            var newPassword = document.getElementById('new_password').value;
            var confirmPassword = document.getElementById('confirm_password').value;
            var passwordError = document.getElementById('passwordError');

            if (newPassword !== confirmPassword) {
                toastr.error("Passwords do not match."); // Toastr error notification
                return false;
            } else {
                toastr.success("Password changed successfully!");  
                return true;
            }
        }

    </script>
</body>
</html>
