<!DOCTYPE html>
<html lang="en">
    <!-- Add this in the head section of your HTML -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email For Link</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: gray;
            margin: 0;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
        }

        form {
            background-color: #ffffff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            width: 350px;
            text-align: center;
        }

        h2 {
            color: red;
        }

        label {
            display: block;
            margin-top: 15px;
            font-weight: bold;
            color: #333;
        }

        input {
            width: 100%;
            padding: 12px;
            margin-top: 8px;
            margin-bottom: 20px;
            box-sizing: border-box;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        button {
            background-color: #28a745;
            color: #fff;
            padding: 12px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            width: 100%;
        }

        button:hover {
            background-color: #218838;
        }
        .logo {
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 20px;
            color: #007bff;
            text-decoration: none;
            font-size: 24px;
            font-weight: bold;
        }

        .logo img {
            height: 50px;
            margin-left: 10px;
        }
    </style>
</head>
<body>
    
<form id="email-form" method="post">
    <!-- <a class="logo" href="#">
        <img class="img-fluid for-light" src="<?= base_url('assets/images/logo/quotation.jpg'); ?>" alt="looginpage">
    </a> -->
    <h2>Enter Email For ResetLink</h2>
    
    <label for="email">Enter your email:</label>
    <input type="email" name="email" id="email" required>
    
    <button type="submit" id="sendResetLink">Send Reset Link</button>
</form>

<script>
    $(document).ready(function() {
        $('#email-form').submit(function(e) {
            e.preventDefault(); 
            var email = $('#email').val();
            $.ajax({
                type: 'POST',
                url: '<?= base_url('channel_partner_auth/send_reset_link'); ?>',
                dataType: 'json',
                data: { email: email },
                success: function(res) {
                    if (res.return) {
                        $('#email-form')[0].reset(); 
                        toastr.success(res.msg);
                    } else {
                        toastr.error(res.msg);
                    }
                },
                error: function(error) {
                    console.log(error);
                    toastr.error('An error occurred. Please try again.');
                }
            });
        });
    });
</script>

</body>
</html>
