<?php


class Channel_partner_model extends CI_Model
{
    public function getChannelPartnerRowData($id)
	{
        $query = $this->db
        ->select('t1.*,t2.name as country_name,t3.name as state_name,t4.name as city_name')
        ->from('channel_partner t1')
        ->join('countries t2', 't2.id = t1.country','left') 
        ->join('states t3', 't3.id = t1.state','left') 
        ->join('cities t4', 't4.id = t1.city','left') 
        ->where(['t1.id'=>$id])
        ->get();
		return $query->row_array();
	}

    //reset password
    public function get_user_id_by_email($email) {
        // Implement the logic to get the user ID by email from the database
        $this->db->select('id');
        $this->db->where('emailid', $email);
        $query = $this->db->get('channel_partner');

        if ($query->num_rows() > 0) {
            return $query->row()->id;
        }

        return false;
    }

    public function save_reset_token($user_id, $token) {
        // Implement the logic to save the reset token in the database
        $data = array('reset_token' => $token);
        $this->db->where('id', $user_id);
        $this->db->update('channel_partner', $data);
    }

    public function update_password_by_token($token, $newPassword) {
        // Check if the token is valid
        $this->db->where('reset_token', $token);
        $query = $this->db->get('channel_partner');

        if ($query->num_rows() > 0) {
            $user = $query->row();
            
            // Update the password
            $data = array('password' => $newPassword); 
            $this->db->where('id', $user->id);
            $this->db->update('channel_partner', $data);

            // Clear the reset token
            $this->db->where('id', $user->id);
            $this->db->update('channel_partner', array('reset_token' => NULL));

            return true; // Password updated successfully
        }

        return false; // Invalid token
    }
}

?>