<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Channel_partner extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Channel Partner';
		//generate executive id
		if($this->model->countData('channel_partner',[]) > 0){
			$number = $this->model->getRowData('channel_partner',[],null,'id','DESC')['id'] + 1;
			$number = sprintf('%03d',$number);
			$data['cpId'] = 'EXE'.$number;
		}else{
			$data['cpId'] = 'EXE'.sprintf('%03d',1);
		}
		$data['countries'] = $this->model->getResultData('countries',[]);
        $page = 'channel_partner/index';
        $this->header_and_footer($page, $data);
    }
	public function addChannelPartner()
    {
		$countEmail = $this->model->countData('channel_partner',['emailid'=>$_POST['emailid']]);
		if($countEmail > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		}
		else
		{
			if($_POST['fullname'])
			{
				$array = array(
					'fullname' => ucfirst($_POST['fullname']),
					'emailid' => $_POST['emailid'],
					'password' => md5($_POST['password']),	
					'mobile' =>  '+'.$_POST['ccode'].' '.$_POST['mobile'],
					'cp_id' => $_POST['cp_id'],
					'gender' => $_POST['gender'],
					'dob' => $_POST['dob'],
					'address' => $_POST['address'],
					'doa' => $_POST['doa'],
					'education' => $_POST['education'],
					'company_name' => $_POST['company_name'],
					'gst_no' => $_POST['gst_no'],
					'pincode' => $_POST['pincode'],
					'country' => $_POST['country'],
					'state' => $_POST['state'],
					'city' => $_POST['city'],
				);
				if($this->model->add('channel_partner',$array))
				{
					$lead_id = $this->db->insert_id();
					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
				
			}
		}
    }
	public function viewChannelPartner()
    {
		$data['list'] = $this->model->getResultData('channel_partner',[]);
		$this->load->view('channel_partner/tb',$data);
    }
	public function editChannelPartner()
    {
        $response=array();
		$data = $this->model->getRowData('channel_partner',['id' => $_POST['id']]);
		if($data['mobile'] !== '')
		{
			$mob = explode(' ',$data['mobile']);
			$ccode = $mob[0];
			$contact = $mob[1];
		}else{
			$mob = '';
			$ccode = '';
			$contact = '';
		}
		$response = array(
			'id' => $_POST['id'],
			'fullname' => $data['fullname'],
			'email' => $data['emailid'],
			'mobile' => $contact,
			'ccode' => str_replace("+","",$ccode),
			'cp_id' => $data['cp_id'],
			'gender' => $data['gender'],
			'dob' => $data['dob'],
			'address' => $data['address'],
			'doa' => $data['doa'],
			'education' => $data['education'],
			'company_name' => $data['company_name'],
			'gst_no' => $data['gst_no'],
			'pincode' => $data['pincode'],
			'country' => $data['country'],
			'state' => $data['state'],
			'city' => $data['city'],
		);
		echo json_encode($response);
    }
	public function updateChannelPartner()
    {
		$countEmail = $this->model->countData('channel_partner',['emailid'=>$_POST['emailid'],'id!='=>$_POST['id']]);
		if($countEmail > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		}
		else
		{
			if(isset($_POST['id']))
			{
				$array = array(
					'fullname' => ucfirst($_POST['fullname']),
					'emailid' => $_POST['emailid'],
					'mobile' =>  '+'.$_POST['ccode'].' '.$_POST['mobile'],
					'cp_id' => $_POST['cp_id'],
					'gender' => $_POST['gender'],
					'dob' => $_POST['dob'],
					'address' => $_POST['address'],
					'doa' => $_POST['doa'],
					'education' => $_POST['education'],
					'company_name' => $_POST['company_name'],
					'gst_no' => $_POST['gst_no'],
					'pincode' => $_POST['pincode'],
					'country' => $_POST['country'],
					'state' => $_POST['state'],
					'city' => $_POST['city'],
				);
				if($this->model->edit('channel_partner',$array,['id' => $_POST['id']]))
				{
					$lead_id = $_POST['id'];
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
			else
			{
				echo json_encode(['return'=>false,'msg'=>'`id` is required']);
			}
		}
    }
  
	public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Channel Partner Detail';
		$data['data'] = $this->channel_partner_model->getChannelPartnerRowData($id);
        $page = 'channel_partner/detail';
        $this->header_and_footer($page, $data);
    }
	public function changePassword()
    {
        if($_POST['id'])
		{
			if($this->model->edit('channel_partner',['password'=>md5($_POST['password'])],['id' => $_POST['id']]))
			{
				$this->viewChannelPartner();
			}
			
		}
    }
	
}
