<div class="page-body">
          <div class="container-fluid">
            <div class="page-title">
              <div class="row">
                <div class="col-6">
                  <h3><?= $title; ?></h3>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid starts-->
          <div class="container-fluid">
            <div class="row">
              <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                  <div class="row">
                  <div class="col-sm-6">
                    <h5><?= $title; ?></h5>
                  </div>
                  <div class="col-sm-6 text-right">
                    <button class="btn btn-success rounded add-btn" type="button" data-bs-toggle="modal" data-bs-target="#addModal" data-bs-original-title="Add <?= $title; ?>"><i class="fa fa-plus"></i> Add <?= $title; ?></button>
                   </div>
                 </div>
                  </div>
                  <div class="card-body">
                    <div class="table-responsive" id="tb">
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid Ends-->
        </div>
        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="add-form">
                  <div class="row g-2">
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Staff <span class="text-danger">*</span></label>
                      <select class="form-control" id="staff_id" name="staff_id" required>
                          <option value="">Select</option>
                          <?php foreach($staffs as $staff){ ?>
                            <option value="<?= $staff['id'] ?>"><?= $staff['fullname']; ?></option>
                          <?php } ?>
                        </select>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Leave type <span class="text-danger">*</span></label>
                      <select class="form-control" id="leave_type" name="leave_type" required>
                        <option value="">Select</option>
                        <option value="Casual Leave">Casual Leave</option>
                        <option value="Medical Leave">Medical Leave</option>
                        <option value="Other">Other</option>
                      </select>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">From date<span class="text-danger">*</span></label>
                      <input class="form-control" name="from_date" id="from_date" type="date" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">To date<span class="text-danger">*</span></label>
                      <input class="form-control" name="to_date" id="to_date" type="date" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Description</label>
                      <textarea class="form-control" name="description" id="description"></textarea>
                    </div>
                  </div>
                  <button class="btn btn-secondary" type="submit">Save</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>

        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit Leave</h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="edit-form">
                  <div class="row g-2">
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Staff <span class="text-danger">*</span></label>
                      <select class="form-control" id="e_staff_id" name="staff_id" required>
                          <option value="">Select</option>
                          <?php foreach($staffs as $staff){ ?>
                            <option value="<?= $staff['id'] ?>"><?= $staff['fullname']; ?></option>
                          <?php } ?>
                        </select>
                    </div>    
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Leave type <span class="text-danger">*</span></label>
                      <select class="form-control" id="e_leave_type" name="leave_type" required>
                        <option value="">Select</option>
                        <option value="Casual Leave">Casual Leave</option>
                        <option value="Medical Leave">Medical Leave</option>
                        <option value="Other">Other</option>
                      </select>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">From date<span class="text-danger">*</span></label>
                      <input class="form-control" name="from_date" id="e_from_date" type="date" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">To date<span class="text-danger">*</span></label>
                      <input class="form-control" name="to_date" id="e_to_date" type="date" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Description</label>
                      <textarea class="form-control" name="description" id="e_description"></textarea>
                    </div>
                  </div>
                  <input type="hidden" name="id" id="id">
                  <button class="btn btn-secondary" type="submit">Update</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>
<script>
$(document).ready(function(){
  $('#addModal').modal({
           backdrop: 'static',
           keyboard: false
    })
    $('#editModal').modal({
           backdrop: 'static',
           keyboard: false
    })
viewLeave();
});
function viewLeave()
{
    $.ajax({
      url: "<?= base_url('leave/viewLeave'); ?>",
      method: "POST",
      data: '',
      success:function(res){
          $('#tb').html(res);
      }
  });
}
$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  var formData = new FormData(this);
  $.ajax({
      url: "<?php echo base_url('leave/addLeave'); ?>",
      method: "POST",
      data:  formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#addModal').modal('toggle'); 
          $('#add-form')[0].reset();
          $('#tb').load('<?= base_url('leave/viewLeave'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
});
function editLeave(id)
{
  $.ajax({
      url: "<?php echo base_url('leave/editLeave'); ?>",
      method: "POST",
      data: {
          id:id
      },
      dataType: 'json',
      success:function(res){
        $("#id").val(res.id);
        $("#e_staff_id").val(res.staff_id);
        $("#e_leave_type").val(res.leave_type);
        $("#e_from_date").val(res.from_date);
        $("#e_to_date").val(res.to_date);
        $("#e_description").val(res.description);

      }
  });
};
$("#edit-form").submit(function(e){
  e.preventDefault();
  disableButton();
  var formData = new FormData(this);
  $.ajax({
      url: "<?php echo base_url('leave/updateLeave'); ?>",
      method: "POST",
      data:  formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#editModal').modal('toggle'); 
          viewLeave();
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
});

</script>