<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Marketing_executive extends CI_Controller {

    public function viewMarketingExecutives()   //with or without dealer id
    {
        if(isset($_REQUEST['api_key']) && $_REQUEST['api_key']!=='')
	    {
    	    if($_REQUEST['api_key'] == get_setting()['api_key'])
    	    {
                $where = [];
                if(isset($_REQUEST['dealer_id']) && $_REQUEST['dealer_id']!=='')
                {
                    $where = ['dealer_id'=>$_REQUEST['dealer_id'],'is_suspended'=>0];
                }
                $response = [];
                $list = $this->model->getResultData('marketing_executive',$where);
                foreach($list as $key => $val)
                {
                    if($val['mobile'] !== '')
                    {
                        $mob = explode(' ',$val['mobile']);
                        $ccode = $mob[0];
                        $contact = $mob[1];
                    }else{
                        $mob = '';
                        $ccode = '';
                        $contact = '';
                    }
                    $dealerData = $this->model->getRowData('distributor',['id'=>$val['dealer_id']]);
                    if($dealerData){
                        $dealer_name = $dealerData['fullname'];
                    }else{
                        $dealer_name = '';
                    }
                    $array = array(
                        'id' => $val['id'],
                        'dealer_id' => $val['dealer_id'],
                        'dealer_name' => $val['dealer_name'],
                        'fullname' => $val['fullname'],
                        'email' => $val['emailid'],
                        'mobile' => $contact,
                        'ccode' => str_replace("+","",$ccode),
                        'exe_id' => $val['exe_id'],
                        'gender' => $val['gender'],
                        'dob' => $val['dob'],
                        'address' => $val['address'],
                        'created' => date('d-m-Y',strtotime($val['created'])),
                    );
                   
                    array_push($response,$array);
                }
                echo json_encode(['return'=>true,'list'=>$response]);
    	    }
    	    else
    		{
                echo json_encode(['return'=>false,'msg'=>'Invalid Api key']);
    		}
	    }
	    else
		{
            echo json_encode(['return'=>false,'msg'=>'`api_key` is required']);
		}
    }

    public function marketingExecutiveDetailById()
    {
        if(isset($_REQUEST['api_key']) && $_REQUEST['api_key']!=='')
	    {
    	    if($_REQUEST['api_key'] == get_setting()['api_key'])
    	    {
                if(isset($_REQUEST['executive_id']) && $_REQUEST['executive_id']!=='')
	            {
                    $response = [];
                    $val = $this->model->getRowData('marketing_executive',['id'=>$_REQUEST['executive_id']]);
                   
                    if($val['mobile'] !== '')
                    {
                        $mob = explode(' ',$val['mobile']);
                        $ccode = $mob[0];
                        $contact = $mob[1];
                    }else{
                        $mob = '';
                        $ccode = '';
                        $contact = '';
                    }
                    $dealerData = $this->model->getRowData('distributor',['id'=>$val['dealer_id']]);
                    if($dealerData){
                        $dealer_name = $dealerData['fullname'];
                    }else{
                        $dealer_name = '';
                    }
                    $array = array(
                        'id' => $val['id'],
                        'dealer_id' => $val['dealer_id'],
                        'dealer_name' => $val['dealer_name'],
                        'fullname' => $val['fullname'],
                        'email' => $val['emailid'],
                        'mobile' => $contact,
                        'ccode' => str_replace("+","",$ccode),
                        'exe_id' => $val['exe_id'],
                        'gender' => $val['gender'],
                        'dob' => $val['dob'],
                        'address' => $val['address'],
                        'created' => date('d-m-Y',strtotime($val['created'])),
                    );
                    array_push($response,$array);
                    echo json_encode(['return'=>true,'list'=>$response]);
                }
                else
                {
                    echo json_encode(['return'=>false,'msg'=>'`executive_id` is required']);
                }
    	    }
    	    else
    		{
                echo json_encode(['return'=>false,'msg'=>'Invalid Api key']);
    		}
	    }
	    else
		{
            echo json_encode(['return'=>false,'msg'=>'`api_key` is required']);
		}
    }

    public function addMarketingExecutive()
    {
        if(isset($_POST['api_key']) && $_POST['api_key']!=='')
	    {
    	    if($_POST['api_key'] == get_setting()['api_key'])
    	    {
				if(isset($_POST['emailid']) && $_POST['emailid']!=='' && isset($_POST['fullname']) && $_POST['fullname']!=='')
	    		{	
                    $countEmail = $this->model->countData('marketing_executive',['emailid'=>$_POST['emailid']]);
                    if($countEmail > 0 )
                    {
                        echo json_encode(['return'=>false,'msg'=>'Email already exist']);
                    }
                    else
                    {
                        $array = array(
                            'dealer_id' => $_POST['dealer_id'],
                            'fullname' => ucfirst($_POST['fullname']),
                            'emailid' => $_POST['emailid'],
                            'mobile' =>  '+'.$_POST['ccode'].' '.$_POST['mobile'],
                            'exe_id' => $_POST['exe_id'],
                            'gender' => $_POST['gender'],
                            'dob' => $_POST['dob'],
                            'address' => $_POST['address'],
                        );
                        if($this->model->add('marketing_executive',$array))
                        {
                            echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
                        }
                    }
				}
				else
				{
					echo json_encode(['return'=>false,'msg'=>'emailid,fullname is required']);
				}
    	    }
    	    else
    		{
                echo json_encode(['return'=>false,'msg'=>'Invalid Api key']);
    		}
	    }
	    else
		{
            echo json_encode(['return'=>false,'msg'=>'`api_key` is required']);
		}
    }

    public function updateMarketingExecutive()
    {
        if(isset($_POST['api_key']) && $_POST['api_key']!=='')
	    {
    	    if($_POST['api_key'] == get_setting()['api_key'])
    	    {
				if(isset($_POST['id']) && $_POST['id']!=='')
	    		{	
                    if(isset($_POST['fullname'])){$array['fullname'] = ucfirst($_POST['fullname']);}
        			if(isset($_POST['emailid'])){$array['emailid'] = $_POST['emailid'];}
        			if(isset($_POST['mobile']) && isset($_POST['ccode'])){$array['mobile'] = '+'.$_POST['ccode'].' '.$_POST['mobile'];}
        			if(isset($_POST['gender'])){$array['gender'] = $_POST['gender'];}
        			if(isset($_POST['dob'])){$array['dob'] = $_POST['dob'];}
        			if(isset($_POST['address'])){$array['address'] = $_POST['address'];}
                    if($this->model->edit('marketing_executive',$array,['id' => $_POST['id']]))
                    {
                        echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
                    }
				}
				else
				{
					echo json_encode(['return'=>false,'msg'=>'executive_id is required']);
				}
    	    }
    	    else
    		{
                echo json_encode(['return'=>false,'msg'=>'Invalid Api key']);
    		}
	    }
	    else
		{
            echo json_encode(['return'=>false,'msg'=>'`api_key` is required']);
		}
    }

    


    
}
