<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Order extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
		$this->load->library('upload');

		
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Order';
        $data['customers'] = $this->model->getResultData('customer',['is_suspended'=>0]);
        $data['categories'] = $this->model->getResultData('product_category',['is_disable'=>0]);
        $page = 'order/index';
        $this->header_and_footer($page, $data);
    }
	public function addOrder()
    {
		if($_POST['customer_id'])
		{
			if($this->model->countData('orders',[]) > 0){
				$number = $this->model->getRowData('orders',[],null,'id','DESC')['id'] + 1;
				$number = sprintf('%03d',$number);
			}else{
				$number = sprintf('%03d',1);
			}
			$order_no = 'INTIMAOD'.$number;
			$array = array(
				'order_no' => $order_no,
				'customer_id' => $_POST['customer_id'],
				'category_id' => $_POST['category_id'],
				'product_id' => $_POST['product_id'],
				'design_no' => $_POST['design_no'],
				'operating_side' => $_POST['operating_side'],
				'motor_side' => $_POST['motor_side'],
				'chain_size' => $_POST['chain_size'],
				'size_type' => $_POST['size_type'],
				'width' => $_POST['width'],
				'height' => $_POST['height'],
				'quantity' => $_POST['quantity'],
				'notes' => $_POST['notes'],
			);
			if($this->model->add('orders',$array))
			{
				$lead_id = $this->db->insert_id();
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','Order detail');

				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
			
		}
	}
			
	
	public function viewOrder()
    {
		$data['list'] = $this->order_model->getOrderResultData();
		$this->load->view('order/tb',$data);
    }
	public function editOrder()
    {
        $response=array();
		$data = $this->model->getRowData('orders',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'customer_id' => $data['customer_id'],
			'category_id' => $data['category_id'],
			'product_id' => $data['product_id'],
			'design_no' => $data['design_no'],
			'operating_side' => $data['operating_side'],
			'motor_side' => $data['motor_side'],
			'chain_size' => $data['chain_size'],
			'size_type' => $data['size_type'],
			'width' => $data['width'],
			'height' => $data['height'],
			'quantity' => $data['quantity'],
			'notes' => $data['notes'],
		);
		echo json_encode($response);
    }        
	public function updateOrder()
    {
			if(isset($_POST['id']))
			{
				$array = array(
					'customer_id' => $_POST['customer_id'],
					'category_id' => $_POST['category_id'],
					'product_id' => $_POST['product_id'],
					'design_no' => $_POST['design_no'],
					'operating_side' => $_POST['operating_side'],
					'motor_side' => $_POST['motor_side'],
					'chain_size' => $_POST['chain_size'],
					'size_type' => $_POST['size_type'],
					'width' => $_POST['width'],
					'height' => $_POST['height'],
					'quantity' => $_POST['quantity'],
					'notes' => $_POST['notes'],
				);
				if($this->model->edit('orders',$array,['id'=>$_POST['id']]))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','Order detail');
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
			else
			{
				echo json_encode(['return'=>false,'msg'=>'`id` is required']);
			}
			
		
    }
  
   
	public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Order Detail';
		$data['data'] = $this->order_model->getOrderRowData($id);
        $page = 'order/detail';
        $this->header_and_footer($page, $data);
    }

	public function updateOrderStatus()
    {
        if(isset($_POST['id']))
		{
			$array = array(
				'status' => $_POST['status'],
			);
			if($this->model->edit('orders',$array,['id'=>$_POST['id']]))
			{
				$lead_id = $_POST['id'];
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','order status');
				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
		}
    }
	public function editOrderStatus()
    {
		$data = $this->model->getRowData('orders',['id'=>$_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'status' => $data['status'],
		);
		echo json_encode($response);
    }
	public function orderImage()
    {
		$data['list'] = $this->order_model->orderImage($_POST['order_id']);
    }
	public function addOrderImage()
    {
        if($_POST['order_id'])
		{
			if($this->order_model->addOrderImage($_POST['order_id']))
			{
				$lead_id = $this->db->insert_id();
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','order image');
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
		}
    }
	public function deleteOrderImage()
    {
        if(isset($_POST['image_id']))
		{
			if($this->order_model->deleteOrderImage($_POST['image_id']))
			{
				$lead_id = $_POST['image_id'];
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','order image');
				echo json_encode(['return'=>true,'msg'=>'Image Deleted Successfully']);
			}
		}
    }
	
}
