<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Attendance extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
		$this->load->library('upload');

		
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Attendance';
        $data['staffs'] = $this->model->getResultData('staff',['is_suspended'=>0]);
		$data['list'] = $this->attendance_model->getAttendanceResultData();
        $page = 'attendance/index';
        $this->header_and_footer($page, $data);
    }
	
	public function viewAttendance()
	{
		$staff_id = null;$date = null;
        if(isset($_POST['staff_id']) && $_POST['staff_id']!==''){
            $staff_id = $_POST['staff_id'];
        }if(isset($_POST['date']) && $_POST['date']!==''){
            $date = $_POST['date'];
        }
		$data['list'] = $this->attendance_model->getAttendanceResultData($staff_id,$date);
		$this->load->view('attendance/tb',$data);
	}
	
}
