<?php


class Model extends CI_Model
{
	public function add($table, $data)
	{
		return $this->db->insert($table, $data);
	}
	public function edit($tb,$data,$cond) 
	{
		return $this->db->where($cond)->update($tb,$data);
	}
	public function deleteData($tb,$cond)
	{
	 	return $this->db->where($cond)->delete($tb);
	}
	public function getRowData($table,$cond,$limit=null,$order_column=null,$order_type=null)
	{
		if($order_column!==null){
			$this->db->order_by($order_column,$order_type);
		}
		if($limit!==null){
			$this->db->limit($limit);
		}
		return $this->db->get_where($table, $cond)->row_array();
		  
	}
	public function getResultData($tb,$cond,$limit=null,$order_column=null,$order_type=null)
	{
		if($order_column!==null){
			$this->db->order_by($order_column,$order_type);
		}
		if($limit!==null){
			$this->db->limit($limit);
		}
		return $this->db->get_where($tb, $cond)->result_array();
	}
	public function countData($table,$cond)
	{
		return $this->db->get_where($table, $cond)->num_rows();
	}
	public function fetch_state($cid,$sid)
    {
        $data = $this->db->get_where('states', array('country_id' => $cid))->result_array();
        echo "<option value=''>Select State</option>";
        foreach ($data as $val) {
			if($val['id'] == $sid)
			{
				$sel = 'selected';
			}
			else
			{
				$sel = '';
			}
            echo "<option value='" . $val['id'] . "' ".$sel.">" . $val['name'] . "</option>";
        }
    }
	public function fetch_city($sid,$cid)
    {
        $data = $this->db->get_where('cities', array('state_id' => $sid))->result_array();
        echo "<option value=''>Select City</option>";
        foreach ($data as $val) {
			if($val['id'] == $cid)
			{
				$sel = 'selected';
			}
			else
			{
				$sel = '';
			}
            echo "<option value='" . $val['id'] . "' ".$sel.">" . $val['name'] . "</option>";
        }
    }
	public function fetch_state2($cid,$sid)
    {
        $data = $this->db->get_where('states', array('country_id' => $cid))->result_array();
        echo "<option value=''>Select State</option>";
        foreach ($data as $val) {
			if($val['id'] == $sid)
			{
				$sel = 'selected';
			}
			else
			{
				$sel = '';
			}
            echo "<option value='" . $val['name'] . "' data-id='" . $val['id'] . "' ".$sel.">" . $val['name'] . "</option>";
        }
    }
	public function fetch_city2($sid,$cid)
    {
        $data = $this->db->get_where('cities', array('state_id' => $sid))->result_array();
        echo "<option value=''>Select City</option>";
        foreach ($data as $val) {
			if($val['id'] == $cid)
			{
				$sel = 'selected';
			}
			else
			{
				$sel = '';
			}
            echo "<option value='" . $val['name'] . "' data-id='" . $val['id'] . "'  ".$sel.">" . $val['name'] . "</option>";
        }
    }



// model
	public function fetch_price($product_id)
	{
		$data = $this->db->get_where('product', array('id' => $product_id))->row_array();
		return $data;
	}

	public function fetch_vendor_branch($vid,$bid)
    {
        $data = $this->db->get_where('vendor_branch', array('vendor_id' => $vid))->result_array();
        echo "<option value=''>Select Branch</option>";
        foreach ($data as $val) {
			if($val['id'] == $bid)
			{
				$sel = 'selected';
			}
			else
			{
				$sel = '';
			}
            echo "<option value='" . $val['id'] . "' ".$sel.">" . $val['name'] . "</option>";
        }
    }
	public function fetch_quotation($customer_id, $quotation_id) {
		$this->db->distinct();
		$this->db->select('quotation_id');
		$this->db->where('customer_id', $customer_id);
		$data = $this->db->get('quotation')->result_array();
	
		echo "<option value=''>Select Quotation</option>";
		foreach ($data as $val) {
			$sel = ($val['quotation_id'] == $quotation_id) ? 'selected' : '';
			echo "<option value='" . $val['quotation_id'] . "' ".$sel.">" . $val['quotation_id'] . "</option>";
		}
	}
	
	public function fetch_bill($quotation_id, $amount) {
		$data = $this->db->get_where('quotation', array('quotation_id' => $quotation_id))->result_array();
		
		echo "<option value=''>Select Amount</option>";
		foreach ($data as $val) {
			$sel = ($val['amount'] == $amount) ? 'selected' : '';
			echo "<option value='" . $val['amount'] . "' ".$sel.">" . $val['amount'] . "</option>";
		}
	}
	
public function send_otp($mobile,$otp) {
		//Your authentication key
	  $authKey = "43960A85hPH9eE54f691c4";
	  $dlt = "1007160969008190519";
	  
	  //Multiple mobiles numbers separated by comma
	  $mobileNumber = '91'."$mobile";
	  
	  //Sender ID,While using route4 sender id should be 6 characters long.
	  $senderId = "TCHICM";
	  
	  //Your message to send, Add URL encoding here.
	  $message = urlencode("Hi! Please enter $otp as your OTP to proceed further. Techicom");
	  // echo $message;
	  // die('B');
	  //Define route 
	  $route    = "4";
	  //Prepare you post parameters
	  $postData = array(
		  'authkey' => $authKey,
		  'mobiles' => $mobileNumber,
		  'message' => $message,
		  'sender' => $senderId,
		  'route' => $route,
		  'DLT_TE_ID' => $dlt
	  );
	  
	  //API URL
	  $url = "https://control.msg91.com/api/sendhttp.php";
	  
	  // init the resource
	  $ch = curl_init();
	  curl_setopt_array($ch, array(
		  CURLOPT_URL => $url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_POST => true,
		  CURLOPT_POSTFIELDS => $postData
		  //,CURLOPT_FOLLOWLOCATION => true
	  ));
	  
	  
	  //Ignore SSL certificate verification
	  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	  
	  
	  //get response
	  $output = curl_exec($ch);
	  //Print error if any
	  if (curl_errno($ch)) {
		  $error = 'error:' . curl_error($ch);
	  }
	  
	   curl_close($ch);
		  $response['isSuccess'] = true;
	  $response['message'] = 'Application place succeessfully';
	  return true;
		  // json_encode($output);
	  
	}
	public function order_placed_sms($user_id,$product_id,$order_id) {
		$userData = $this->db->get_where('user',['id'=>$user_id])->row_array();
		$productData = $this->db->get_where('product',['id'=>$product_id])->row_array();
		$mobile = $userData['mobile'];
		$user_name = $userData['fullname'];
		$user_name = $productData['name'];
		//Your authentication key
	  $authKey = "43960A85hPH9eE54f691c4";
	  $dlt = "1207165114884200109";
	  
	  //Multiple mobiles numbers separated by comma
	  $mobileNumber = '91'."$mobile";
	  
	  //Sender ID,While using route4 sender id should be 6 characters long.
	  $senderId = "TECHHO";
	  
	  //Your message to send, Add URL encoding here.
	  $message = urlencode("Hi! Please enter $order_id as your OTP for login into the mobile application. - Techicom");
	  // echo $message;
	  // die('B');
	  //Define route 
	  $route    = "4";
	  //Prepare you post parameters
	  $postData = array(
		  'authkey' => $authKey,
		  'mobiles' => $mobileNumber,
		  'message' => $message,
		  'sender' => $senderId,
		  'route' => $route,
		  'DLT_TE_ID' => $dlt
	  );
	  
	  //API URL
	  $url = "https://control.msg91.com/api/sendhttp.php";
	  
	  // init the resource
	  $ch = curl_init();
	  curl_setopt_array($ch, array(
		  CURLOPT_URL => $url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_POST => true,
		  CURLOPT_POSTFIELDS => $postData
		  //,CURLOPT_FOLLOWLOCATION => true
	  ));
	  
	  
	  //Ignore SSL certificate verification
	  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	  
	  
	  //get response
	  $output = curl_exec($ch);
	  //Print error if any
	  if (curl_errno($ch)) {
		  $error = 'error:' . curl_error($ch);
	  }
	  
	   curl_close($ch);
		  $response['isSuccess'] = true;
	  $response['message'] = 'Application place succeessfully';
	  return true;
		  // json_encode($output);
	  
	}
	
	public function fetch_product($cid,$pid)
    {
        $data = $this->db->get_where('product', array('category_id' => $cid))->result_array();
        echo "<option value=''>Select Product</option>";
        foreach ($data as $val) {
			if($val['id'] == $pid)
			{
				$sel = 'selected';
			}
			else
			{
				$sel = '';
			}
            echo "<option value='" . $val['id'] . "' ".$sel.">" . $val['name'] . "</option>";
        }
    }

	public function fetch_commision_level_by_cp($cp_id)
    {
        $cp_data = $this->db->get_where('channel_partner', array('id' => $cp_id))->row_array();
		if($cp_data['commision_level_id']){
        	$commision_level_data = $this->db->get_where('commision_level', array('id' => $cp_data['commision_level_id']))->row_array();
			echo "<p class='text-success'>Commision level - ".$commision_level_data['name']."</p>";
		}else{
			echo "<p class='text-danger'>No commision level assigned!!</p>";
		}
    }
	public function fetch_commision($p_id,$cp_id,$order_value)
    {
        $cp_data = $this->db->get_where('channel_partner', array('id' => $cp_id))->row_array();
		if($cp_data['commision_level_id']){
        	$commision_data = $this->db->get_where('commision', array('product_id' => $p_id,'commision_level_id' => $cp_data['commision_level_id']))->row_array();
			$commision_percentage =  $commision_data['commision_percentage'];
			$commision = ($order_value*$commision_percentage)/100;
			echo $commision;
		}else{
			echo "";
		}
    }
}

?>