<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Payout extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
		$this->load->library('upload');

		
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Payout';
        $data['channel_partners'] = $this->model->getResultData('channel_partner',['is_suspended'=>0]);
		// print_r($data['channel_partners']);die();
        $page = 'payout/index';
        $this->header_and_footer($page, $data);
    }
	
	
	public function addPayout()
	{
		if($_POST['amount'])
		{
			if(isset($_POST['channel_partner_id'])){
				$channel_partner_id = $_POST['channel_partner_id'];
			}else{
				$channel_partner_id = $this->session->userdata('id');
			}
			$array = array(
				'channel_partner_id' => $channel_partner_id,
				'reference_id' => $_POST['reference_id'],
				'amount' => $_POST['amount'],
				'payment_mode' => $_POST['payment_mode'],
				'note' => $_POST['note'],
			);
			if($this->model->add('payout',$array))
			{
				$lead_id = $this->db->insert_id();
				// $this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','payout');
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
		}
	}
	public function viewPayout()
	{
		$where = [];
        if(isset($_POST['channel_partner_id']) && $_POST['channel_partner_id']!==''){
            $where = ['channel_partner_id'=>$_POST['channel_partner_id']];
        }
		if($this->session->userdata('usertype') == 'channel_partner'){
            $where = ['channel_partner_id'=>$this->session->userdata('id')];
        }
		$data['list'] = $this->model->getResultData('payout',$where,null,'id','DESC');
		$this->load->view('payout/tb',$data);
	}
	public function editPayout()
	{
		$data = $this->model->getRowData('payout',['id'=>$_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'channel_partner_id' => $data['channel_partner_id'],
			'reference_id' => $data['reference_id'],
			'amount' => $data['amount'],
			'payment_mode' => $data['payment_mode'],
			'note' => $data['note'],
		);
		echo json_encode($response);
	}
	public function updatePayout()
	{
		if(isset($_POST['id']))
		{
			$array = array(
				'channel_partner_id' => $_POST['channel_partner_id'],
				'reference_id' => $_POST['reference_id'],
				'amount' => $_POST['amount'],
				'payment_mode' => $_POST['payment_mode'],
				'note' => $_POST['note'],
			);
			if($this->model->edit('payout',$array,['id'=>$_POST['id']]))
			{
				$lead_id = $_POST['id'];
				// $this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','payout detail');
				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
		}
	}

	public function calculate_pending_commision()
    {
        if ($this->input->post('channel_partner_id')) {
            $cp_id = $this->input->post('channel_partner_id');
            $this->payout_model->calculate_pending_commision($cp_id);
        }
    }
	
}
